/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.Trace;
import com.streamscape.cli.ClientContext;
import com.streamscape.cli.ClientState;
import com.streamscape.cli.ds.DataCollection;
import com.streamscape.cli.ds.collection.Aspects;
import com.streamscape.cli.ds.collection.AuditQueue;
import com.streamscape.cli.ds.collection.BlockingQueue;
import com.streamscape.cli.ds.collection.DirectoryTable;
import com.streamscape.cli.ds.collection.EventQueue;
import com.streamscape.cli.ds.collection.EventTable;
import com.streamscape.cli.ds.collection.Facets;
import com.streamscape.cli.ds.collection.FileTable;
import com.streamscape.cli.ds.collection.MessageQueue;
import com.streamscape.cli.ds.collection.ProcessQueue;
import com.streamscape.cli.ds.collection.SourceStream;
import com.streamscape.cli.ds.collection.Table;
import com.streamscape.cli.ds.collection.View;
import com.streamscape.cli.ds.collection.VirtualTable;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.sdo.EventPropertyValidator;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.PropertyType;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowArray;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.evtrigger.function.SemanticTypeLookupContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContextImpl;
import com.streamscape.sef.evtrigger.function.TriggerFunctionTokenType;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnit;
import com.streamscape.sef.evtrigger.function.types.AbstractObjectType;
import com.streamscape.sef.evtrigger.function.types.ArrayType;
import com.streamscape.sef.evtrigger.function.types.BigDecimalType;
import com.streamscape.sef.evtrigger.function.types.BigIntegerType;
import com.streamscape.sef.evtrigger.function.types.BooleanType;
import com.streamscape.sef.evtrigger.function.types.ByteType;
import com.streamscape.sef.evtrigger.function.types.CharType;
import com.streamscape.sef.evtrigger.function.types.CollectionType;
import com.streamscape.sef.evtrigger.function.types.DataCollectionType;
import com.streamscape.sef.evtrigger.function.types.DataspaceFunctionUnitType;
import com.streamscape.sef.evtrigger.function.types.DateType;
import com.streamscape.sef.evtrigger.function.types.DoubleType;
import com.streamscape.sef.evtrigger.function.types.EnumType;
import com.streamscape.sef.evtrigger.function.types.EventType;
import com.streamscape.sef.evtrigger.function.types.FloatType;
import com.streamscape.sef.evtrigger.function.types.IntType;
import com.streamscape.sef.evtrigger.function.types.ListType;
import com.streamscape.sef.evtrigger.function.types.LongType;
import com.streamscape.sef.evtrigger.function.types.MapType;
import com.streamscape.sef.evtrigger.function.types.NullType;
import com.streamscape.sef.evtrigger.function.types.ObjectType;
import com.streamscape.sef.evtrigger.function.types.QueueType;
import com.streamscape.sef.evtrigger.function.types.RuntimeFunctionUnitType;
import com.streamscape.sef.evtrigger.function.types.SQLDateType;
import com.streamscape.sef.evtrigger.function.types.SQLTimestampType;
import com.streamscape.sef.evtrigger.function.types.SemanticTypeType;
import com.streamscape.sef.evtrigger.function.types.ServiceFunctionUnitType;
import com.streamscape.sef.evtrigger.function.types.SetType;
import com.streamscape.sef.evtrigger.function.types.ShortType;
import com.streamscape.sef.evtrigger.function.types.StringType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.VoidType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class TypeFactory {
    private static Map<TriggerFunctionTokenType, Type<?>> triggerFunctionTokenToType = new ConcurrentHashMap();
    public static final Type<String> STRING = new StringType();
    public static final Type<Integer> INT = new IntType();
    public static final Type<Short> SHORT = new ShortType();
    public static final Type<Long> LONG = new LongType();
    public static final Type<Float> FLOAT = new FloatType();
    public static final Type<Double> DOUBLE = new DoubleType();
    public static final Type<Byte> BYTE = new ByteType();
    public static final Type<BigInteger> BIGINTEGER = new BigIntegerType();
    public static final Type<Boolean> BOOLEAN = new BooleanType();
    public static final Type<Character> CHAR = new CharType();
    public static final Type<Date> DATE = new DateType();
    public static final Type<java.sql.Date> SQL_DATE = new SQLDateType();
    public static final Type<Timestamp> SQL_TIMESTAMP = new SQLTimestampType();
    public static final Type<Object> NULLTYPE = new NullType();
    public static final Type<Object> VOIDTYPE = new VoidType();
    public static final Type<List<?>> LIST = new ListType();
    public static final Type<Set<?>> SET = new SetType();
    public static final Type<Collection<?>> COLLECTION = new CollectionType();
    public static final Type<BlockingQueue> BLOCKING_QUEUE = new DataCollectionType.BlockingQueueType();
    public static final Type<EventQueue> EVENT_QUEUE = new DataCollectionType.EventQueueType();
    public static final Type<AuditQueue> AUDIT_QUEUE = new DataCollectionType.AuditQueueType();
    public static final Type<MessageQueue> MESSAGE_QUEUE = new DataCollectionType.MessageQueueType();
    public static final Type<ProcessQueue> PROCESS_QUEUE = new DataCollectionType.ProcessQueueType();
    public static final Type<Table> TABLE = new DataCollectionType.TableType();
    public static final Type<EventTable> EVENT_TABLE = new DataCollectionType.EventTableType();
    public static final Type<FileTable> FILE_TABLE = new DataCollectionType.FileTableType();
    public static final Type<VirtualTable> VIRTUAL_TABLE = new DataCollectionType.VirtualTableType();
    public static final Type<DirectoryTable> DIRECTORY = new DataCollectionType.DirectoryType();
    public static final Type<View> VIEW = new DataCollectionType.ViewType();
    public static final Type<SourceStream> SOURCE_STREAM = new DataCollectionType.SourceStreamType();
    public static final Type<DataCollection> DATASPACE_COLLECTION = new DataCollectionType.DataspaceCollectionType();
    public static final Type<FunctionsUnit> DATASPACE = new DataspaceFunctionUnitType();
    public static final Type<FunctionsUnit> SERVICE = new ServiceFunctionUnitType();
    public static final Type<FunctionsUnit> RUNTIME = new RuntimeFunctionUnitType();
    public static volatile SemanticTypeLookupContext currentSemanticTypeLookupContext = null;
    private static Pattern LONG_NUMBER_PATTERN;
    private static Pattern DOUBLE_NUMBER_PATTERN;
    private static Pattern HEX_PATTERN;

    private static void registerType(Type<?> type, TriggerFunctionTokenType tokenType) {
        triggerFunctionTokenToType.put(tokenType, type);
    }

    public static Type<?> getType(TriggerFunctionTokenType tokenType) {
        if (tokenType == null) {
            return null;
        }
        if (tokenType == TriggerFunctionTokenType.EVENT) {
            return new EventType();
        }
        if (tokenType == TriggerFunctionTokenType.OBJECT) {
            return TypeFactory.createObjectType();
        }
        if (tokenType == TriggerFunctionTokenType.BIGDECIMAL) {
            return TypeFactory.createBigDecimalType();
        }
        if (tokenType == TriggerFunctionTokenType.MAP) {
            return TypeFactory.createMapType();
        }
        if (tokenType == TriggerFunctionTokenType.QUEUE) {
            return TypeFactory.createQueueType();
        }
        if (tokenType == TriggerFunctionTokenType.ROW) {
            return TypeFactory.createSemanticTypeType("Row", Row.class.getName());
        }
        if (tokenType == TriggerFunctionTokenType.ROWSET) {
            return TypeFactory.createSemanticTypeType("RowSet", RowSet.class.getName());
        }
        if (tokenType == TriggerFunctionTokenType.ROWARRAY) {
            return TypeFactory.createSemanticTypeType("RowArray", RowArray.class.getName());
        }
        if (tokenType == TriggerFunctionTokenType.ENTRY) {
            return TypeFactory.createSemanticTypeType("entry", Map.Entry.class.getName());
        }
        return triggerFunctionTokenToType.get(tokenType);
    }

    public static Type<?> getType(String tokenType) {
        return TypeFactory.getType(TriggerFunctionTokenType.parse(tokenType));
    }

    public static Type<?> getType(Types type) {
        return TypeFactory.getType(type.getName());
    }

    public static Type<?> getBaseType(String typeName) {
        return TypeFactory.getType(TriggerFunctionTokenType.parse(typeName));
    }

    public static Type<?> createType(String typeName, TriggerFunctionParserContext parserContext) throws ClassNotFoundException {
        Type<?> type = TypeFactory.getType(TriggerFunctionTokenType.parse(typeName));
        if (type == null) {
            type = TypeFactory.createSemanticTypeType(typeName, parserContext);
        }
        return type;
    }

    public static Type<?> createSemanticTypeType(String typeName, TriggerFunctionParserContext parserContext) throws ClassNotFoundException {
        SemanticType semanticType = parserContext.lookupSemanticType(typeName);
        if (semanticType == null) {
            return null;
        }
        Class<?> semanticTypeClass = parserContext.loadClass(semanticType.getClassName());
        Type<?> type = TypeFactory.resolveBasicType(semanticTypeClass);
        if (type != null) {
            return type;
        }
        AbstractObjectType result = EnumType.isEnum(semanticTypeClass) ? new EnumType() : (ImmutableEventDatagram.class.isAssignableFrom(semanticTypeClass) ? new EventType() : new SemanticTypeType());
        result.setSemanticTypeName(typeName);
        result.setSemanticTypeClassName(semanticTypeClass.getName());
        return result;
    }

    public static Type<?> createSemanticTypeType(Class<?> clazz) {
        return TypeFactory.createSemanticTypeType(clazz.getSimpleName(), clazz.getName());
    }

    public static Type<?> createSemanticTypeType(String typeName, String className) {
        SemanticTypeType result = new SemanticTypeType();
        result.setSemanticTypeName(typeName);
        result.setSemanticTypeClassName(className);
        return result;
    }

    public static Type<?> createEnumType(String typeName, String className) {
        EnumType result = new EnumType();
        result.setSemanticTypeName(typeName);
        result.setSemanticTypeClassName(className);
        return result;
    }

    public static EventType createEventType() {
        return TypeFactory.createEventType((String)null, (String)null);
    }

    public static EventType createEventType(String eventModel, Class<?> eventClazz) {
        return TypeFactory.createEventType(eventModel, eventClazz.getName());
    }

    public static EventType createEventType(String eventModel, Class<?> eventClazz, String eventId) {
        return TypeFactory.createEventType(eventModel, eventClazz.getName(), eventId);
    }

    private static EventType createEventType(String eventModel, String className) {
        EventType eventType = new EventType();
        eventType.setSemanticTypeName(eventModel);
        eventType.setSemanticTypeClassName(className);
        return eventType;
    }

    private static EventType createEventType(String eventModel, String eventClass, String eventId) {
        EventType eventType = TypeFactory.createEventType(eventModel, eventClass);
        eventType.setEventId(eventId);
        return eventType;
    }

    public static EventType createEventType(String eventId) {
        EventType eventType = TypeFactory.createEventType();
        eventType.setEventId(eventId);
        return eventType;
    }

    public static EventType createEventType(SemanticTypeLookupContext context, String eventId) throws Exception {
        Prototype eventPrototype = context.lookupEventPrototype(eventId);
        if (eventPrototype == null) {
            throw new Exception("Event prototype [" + eventId + "] does not exist.");
        }
        SemanticType semanticType = context.lookupSemanticType(eventPrototype.getModelName());
        if (semanticType == null) {
            throw new Exception("Semantic type '" + eventPrototype.getModelName() + "' corresponding to event [" + eventId + "] not found.");
        }
        return TypeFactory.createEventType(eventPrototype.getModelName(), semanticType.getClassName(), eventId);
    }

    public static ObjectType createObjectType() {
        ObjectType objectType = new ObjectType();
        objectType.setSemanticTypeName("object");
        objectType.setSemanticTypeClassName(Object.class.getName());
        return objectType;
    }

    public static MapType createMapType() {
        return new MapType();
    }

    public static MapType createDataspaceMapType() {
        MapType mapType = new MapType();
        mapType.setSemanticTypeClassName(com.streamscape.cli.ds.collection.Map.class.getName());
        return mapType;
    }

    public static QueueType createQueueType() {
        return new QueueType();
    }

    public static QueueType createDataspaceQueueType() {
        QueueType queueType = new QueueType();
        queueType.setSemanticTypeClassName(com.streamscape.cli.ds.collection.Queue.class.getName());
        return queueType;
    }

    public static ArrayType createArrayType(Type<?> elementType) {
        return new ArrayType(elementType);
    }

    public static BigDecimalType createBigDecimalType() {
        return new BigDecimalType();
    }

    public static BigDecimalType createBigDecimalType(int precision) {
        return new BigDecimalType(precision);
    }

    public static BigDecimalType createBigDecimalType(int precision, int scale) {
        return new BigDecimalType(precision, scale);
    }

    public static Type<?> resolveFieldType(Field field, SemanticTypeLookupContext context) {
        return TypeFactory.resolveType(field.getType(), context);
    }

    public static Type<?> resolveObjectType(Object object, SemanticTypeLookupContext context) {
        if (object == null) {
            return NULLTYPE;
        }
        Type<?> type = TypeFactory.resolveType(object.getClass(), context);
        if (type != null && type.getType() == Types.EVENT) {
            String eventId = ((ImmutableEventDatagram)object).getEventId();
            if (eventId.startsWith("e.action.")) {
                eventId = eventId.substring("e.action.".length());
            }
            ((EventType)type).setEventId(eventId);
        }
        return type;
    }

    public static Type<?> resolveType(String clazzName, SemanticTypeLookupContext context) throws ClassNotFoundException {
        return TypeFactory.resolveType(context.loadClass(clazzName), context);
    }

    public static Type<?> resolveType(Class<?> clazz, SemanticTypeLookupContext context) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isArray()) {
            Type<?> elementType = TypeFactory.resolveType(clazz.getComponentType(), context);
            if (elementType == null) {
                return null;
            }
            return TypeFactory.createArrayType(elementType);
        }
        Type<?> type = TypeFactory.resolveBasicType(clazz);
        if (type != null) {
            return type;
        }
        AbstractObjectType fieldType = ImmutableEventDatagram.class.isAssignableFrom(clazz) ? new EventType() : (clazz.isEnum() ? new EnumType() : new SemanticTypeType());
        fieldType.setSemanticTypeClassName(clazz.getName());
        if (context != null) {
            SemanticType semanticType = context.lookupSemanticTypeByClass(clazz.getName());
            if (semanticType != null) {
                fieldType.setSemanticTypeName(semanticType.getTypeName());
            } else {
                fieldType.setSemanticTypeName(clazz.getName());
            }
        } else {
            fieldType.setSemanticTypeName(clazz.getName());
        }
        return fieldType;
    }

    public static String resolveTypeName(Class<?> clazz, SemanticTypeLookupContext context) {
        if (clazz != null) {
            Type<?> type = TypeFactory.resolveType(clazz, context);
            return type != null ? type.getName() : clazz.getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SemanticTypeLookupContext getCurrentSemanticTypeLookupContext() {
        if (currentSemanticTypeLookupContext != null) return currentSemanticTypeLookupContext;
        Class<TypeFactory> clazz = TypeFactory.class;
        synchronized (TypeFactory.class) {
            if (currentSemanticTypeLookupContext != null) return currentSemanticTypeLookupContext;
            if (RuntimeState.isActive()) {
                currentSemanticTypeLookupContext = new TriggerFunctionParserContextImpl(RuntimeContext.getInstance());
            } else {
                if (!ClientState.isActive()) return currentSemanticTypeLookupContext;
                currentSemanticTypeLookupContext = new TriggerFunctionParserContextImpl(ClientContext.getInstance());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return currentSemanticTypeLookupContext;
        }
    }

    public static Type<?> resolveBasicType(Class<?> clazz) {
        if (clazz == null) {
            return NULLTYPE;
        }
        if (clazz.isArray()) {
            Type<?> elementType = TypeFactory.resolveBasicType(clazz.getComponentType());
            if (elementType == null) {
                return null;
            }
            return TypeFactory.createArrayType(elementType);
        }
        if (clazz == String.class) {
            return STRING;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return INT;
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return SHORT;
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return BYTE;
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return LONG;
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return FLOAT;
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return DOUBLE;
        }
        if (clazz == BigDecimal.class) {
            return TypeFactory.createBigDecimalType();
        }
        if (clazz == BigInteger.class) {
            return BIGINTEGER;
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return BOOLEAN;
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return CHAR;
        }
        if (clazz == Date.class) {
            return DATE;
        }
        if (clazz == java.sql.Date.class) {
            return SQL_DATE;
        }
        if (clazz == Timestamp.class) {
            return SQL_TIMESTAMP;
        }
        if (clazz == Object.class) {
            return TypeFactory.createObjectType();
        }
        if (clazz == Void.TYPE) {
            return VOIDTYPE;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return LIST;
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return SET;
        }
        if (Collection.class.isAssignableFrom(clazz) && clazz != Aspects.class) {
            return COLLECTION;
        }
        if (com.streamscape.cli.ds.collection.Map.class.isAssignableFrom(clazz)) {
            return TypeFactory.createDataspaceMapType();
        }
        if (Map.class.isAssignableFrom(clazz) && clazz != Facets.class) {
            return TypeFactory.createMapType();
        }
        if (com.streamscape.cli.ds.collection.Queue.class.isAssignableFrom(clazz)) {
            return TypeFactory.createDataspaceQueueType();
        }
        if (Queue.class.isAssignableFrom(clazz)) {
            return TypeFactory.createQueueType();
        }
        return null;
    }

    public static Class<?> resolveClass(Type<?> type, SemanticTypeLookupContext context) throws ClassNotFoundException {
        if (type == null) {
            throw new ClassNotFoundException("null");
        }
        switch (type.getType()) {
            case STRING: {
                return String.class;
            }
            case INT: {
                return Integer.class;
            }
            case SHORT: {
                return Short.class;
            }
            case BYTE: {
                return Byte.class;
            }
            case LONG: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case BIGDECIMAL: {
                return BigDecimal.class;
            }
            case BIGINT: {
                return BigInteger.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
            case CHAR: {
                return Character.class;
            }
            case DATE: {
                return Date.class;
            }
            case SQL_DATE: {
                return java.sql.Date.class;
            }
            case SQL_TIMESTAMP: {
                return Timestamp.class;
            }
            case VOID: {
                return Void.TYPE;
            }
            case NULLTYPE: {
                return null;
            }
            case OBJECT: {
                if (((ObjectType)type).getRealType() != null) {
                    return TypeFactory.resolveClass(((ObjectType)type).getRealType(), context);
                }
                return Object.class;
            }
            case EVENT: {
                try {
                    ((EventType)type).resolveEventType(context);
                }
                catch (Exception exception) {
                    Trace.logDebug(TypeFactory.class, "Failed to resolve event type for event [" + String.valueOf(type) + "]. Cause: " + exception.getMessage());
                }
                if (((EventType)type).getSemanticTypeClassName() != null) {
                    return context.loadClass(((EventType)type).getSemanticTypeClassName());
                }
                return ImmutableEventDatagram.class;
            }
            case SEMANTIC_TYPE: 
            case ENUM: {
                AbstractObjectType semanticType = (AbstractObjectType)type;
                if (semanticType.getSemanticTypeClassName() != null) {
                    return context.loadClass(semanticType.getSemanticTypeClassName());
                }
            }
            case ARRAY: {
                return Array.newInstance(TypeFactory.resolveClass(((ArrayType)type).getElementType(), context), 0).getClass();
            }
            case LIST: {
                return ArrayList.class;
            }
            case SET: {
                return HashSet.class;
            }
            case QUEUE: {
                return ArrayBlockingQueue.class;
            }
            case MAP: {
                return HashMap.class;
            }
        }
        throw new ClassNotFoundException(type.getName());
    }

    public static Class<?> wrapPrimitive(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.TYPE) {
            clazz = Integer.class;
        } else if (clazz == Short.TYPE) {
            clazz = Short.class;
        } else if (clazz == Byte.TYPE) {
            clazz = Byte.class;
        } else if (clazz == Long.TYPE) {
            clazz = Long.class;
        } else if (clazz == Float.TYPE) {
            clazz = Float.class;
        } else if (clazz == Double.TYPE) {
            clazz = Double.class;
        } else if (clazz == Boolean.TYPE) {
            clazz = Boolean.class;
        } else if (clazz == Character.TYPE) {
            clazz = Character.class;
        }
        return clazz;
    }

    public static Object wrapPrimitiveValue(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClazz = value.getClass();
        if (valueClazz.isArray()) {
            Class<?> valueElementClass = valueClazz.getComponentType();
            if (valueElementClass.isPrimitive()) {
                Object result = Array.newInstance(TypeFactory.wrapPrimitive(valueElementClass), Array.getLength(value));
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Array.set(result, i, TypeFactory.wrapPrimitiveValue(Array.get(value, i)));
                }
                return result;
            }
            return value;
        }
        if (!valueClazz.isPrimitive()) {
            return value;
        }
        if (valueClazz == Integer.TYPE) {
            return (Integer)value;
        }
        if (valueClazz == Short.TYPE) {
            return (Short)value;
        }
        if (valueClazz == Byte.TYPE) {
            return (Byte)value;
        }
        if (valueClazz == Long.TYPE) {
            return (Long)value;
        }
        if (valueClazz == Float.TYPE) {
            return (Float)value;
        }
        if (valueClazz == Double.TYPE) {
            return (Double)value;
        }
        if (valueClazz == Boolean.TYPE) {
            return (Boolean)value;
        }
        if (valueClazz == Character.TYPE) {
            return (Character)value;
        }
        return value;
    }

    public static Object unwrapBoxerValue(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClazz = value.getClass();
        if (valueClazz.isArray()) {
            Class<?> valueElementClass = valueClazz.getComponentType();
            if (!valueElementClass.isPrimitive()) {
                Object result = Array.newInstance(TypeFactory.unwrapBoxer(valueElementClass), Array.getLength(value));
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Array.set(result, i, TypeFactory.unwrapBoxerValue(Array.get(value, i)));
                }
                return result;
            }
            return value;
        }
        if (valueClazz.isPrimitive()) {
            return value;
        }
        if (valueClazz == Integer.class) {
            return (int)((Integer)value);
        }
        if (valueClazz == Short.class) {
            return (short)((Short)value);
        }
        if (valueClazz == Byte.class) {
            return (byte)((Byte)value);
        }
        if (valueClazz == Long.class) {
            return (long)((Long)value);
        }
        if (valueClazz == Float.class) {
            return Float.valueOf(((Float)value).floatValue());
        }
        if (valueClazz == Double.class) {
            return (double)((Double)value);
        }
        if (valueClazz == Boolean.class) {
            return (boolean)((Boolean)value);
        }
        if (valueClazz == Character.class) {
            return Character.valueOf(((Character)value).charValue());
        }
        return value;
    }

    public static Class<?> unwrapBoxer(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.class) {
            clazz = Integer.TYPE;
        } else if (clazz == Short.class) {
            clazz = Short.TYPE;
        } else if (clazz == Byte.class) {
            clazz = Byte.TYPE;
        } else if (clazz == Long.class) {
            clazz = Long.TYPE;
        } else if (clazz == Float.class) {
            clazz = Float.TYPE;
        } else if (clazz == Double.class) {
            clazz = Double.TYPE;
        } else if (clazz == Boolean.class) {
            clazz = Boolean.TYPE;
        } else if (clazz == Character.class) {
            clazz = Character.TYPE;
        }
        return clazz;
    }

    public static Object wrapUnwrapValue(Class<?> toClazz, Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClazz = value.getClass();
        if (toClazz == valueClazz) {
            return value;
        }
        if (toClazz.isPrimitive() && TypeFactory.wrapPrimitive(toClazz) == valueClazz) {
            return TypeFactory.unwrapBoxerValue(value);
        }
        if (toClazz.isArray() && toClazz.getComponentType().isPrimitive()) {
            return TypeFactory.unwrapBoxerValue(value);
        }
        if (valueClazz.isPrimitive() && TypeFactory.wrapPrimitive(valueClazz) == toClazz) {
            return TypeFactory.wrapPrimitiveValue(value);
        }
        if (valueClazz.isArray() && valueClazz.getComponentType().isPrimitive()) {
            return TypeFactory.wrapPrimitiveValue(value);
        }
        return value;
    }

    public static Type<?> convertFromEventPropertyType(PropertyType propertyType, Object propertyValue) {
        switch (propertyType) {
            case Boolean: {
                return BOOLEAN;
            }
            case Byte: {
                return BYTE;
            }
            case Short: {
                return SHORT;
            }
            case Integer: {
                return INT;
            }
            case Long: {
                return LONG;
            }
            case Float: {
                return FLOAT;
            }
            case Double: {
                return DOUBLE;
            }
            case BigDecimal: {
                return TypeFactory.createBigDecimalType(EventPropertyValidator.getBigDecimalPrecision(propertyValue), EventPropertyValidator.getBigDecimalScale(propertyValue));
            }
            case String: {
                return STRING;
            }
        }
        return TypeFactory.createObjectType();
    }

    public static Object convertPropertyValue(PropertyType propertyType, Object value) {
        if (value == null) {
            return value;
        }
        switch (propertyType) {
            case BigDecimal: {
                if (value instanceof BigDecimal) break;
                if (value instanceof Number) {
                    value = BigDecimal.valueOf(((Number)value).doubleValue());
                    break;
                }
                value = new BigDecimal(value.toString());
                break;
            }
            case Boolean: {
                if (value instanceof Boolean) break;
                value = Boolean.valueOf(value.toString());
                break;
            }
            case Byte: {
                if (value instanceof Number) {
                    value = ((Number)value).byteValue();
                    break;
                }
                value = Byte.valueOf(value.toString());
                break;
            }
            case Double: {
                if (value instanceof Number) {
                    value = ((Number)value).doubleValue();
                    break;
                }
                value = Double.valueOf(value.toString());
                break;
            }
            case Float: {
                if (value instanceof Number) {
                    value = Float.valueOf(((Number)value).floatValue());
                    break;
                }
                value = Float.valueOf(value.toString());
                break;
            }
            case Integer: {
                if (value instanceof Number) {
                    value = ((Number)value).intValue();
                    break;
                }
                value = Integer.valueOf(value.toString());
                break;
            }
            case Long: {
                if (value instanceof Number) {
                    value = ((Number)value).longValue();
                    break;
                }
                value = Long.valueOf(value.toString());
                break;
            }
            case Short: {
                if (value instanceof Number) {
                    value = ((Number)value).shortValue();
                    break;
                }
                value = Short.valueOf(value.toString());
                break;
            }
            case String: {
                if (value instanceof String) break;
                value = value.toString();
            }
        }
        return value;
    }

    public static Type<?> defineNumberType(String value) {
        if (LONG_NUMBER_PATTERN.matcher(value).matches()) {
            if (value.endsWith("L") || value.endsWith("l")) {
                return LONG;
            }
            return INT;
        }
        if (TypeFactory.isHex(value)) {
            if (value.endsWith("L") || value.endsWith("l")) {
                return LONG;
            }
            return INT;
        }
        if (DOUBLE_NUMBER_PATTERN.matcher(value).matches()) {
            if (value.endsWith("f") || value.endsWith("F")) {
                return FLOAT;
            }
            return DOUBLE;
        }
        return null;
    }

    public static boolean isHex(String value) {
        return HEX_PATTERN.matcher(value).matches();
    }

    public static long fromHex(String value) {
        if (!value.startsWith("0x")) {
            throw new NumberFormatException("Wrong hex value '" + value + "'.");
        }
        long result = 0L;
        int length = value.length();
        if (value.endsWith("l") || value.endsWith("L")) {
            --length;
        }
        for (int i = length; i > 2; --i) {
            int c = value.charAt(i - 1);
            if (c <= 57) {
                c = 48;
            } else if (c <= 70) {
                c = 55;
            } else if (c <= 102) {
                c = 87;
            }
            result += (long)((byte)(value.charAt(i - 1) - c)) * (long)Math.pow(16.0, length - i);
        }
        return result;
    }

    public static boolean isObjectType(Type<?> type) {
        return type != null && type.getType() == Types.OBJECT;
    }

    public static Types unwrapObjectType(Type<?> type) {
        if (TypeFactory.isObjectType(type) && ((ObjectType)type).getRealType() != null) {
            return ((ObjectType)type).getRealType().getType();
        }
        return null;
    }

    public static boolean isPrimitive(Class clazz) {
        return clazz.isPrimitive() || clazz.equals(String.class) || clazz.equals(Class.class) || TypeFactory.unwrapBoxer(clazz).isPrimitive();
    }

    static {
        TypeFactory.registerType(STRING, TriggerFunctionTokenType.STRING);
        TypeFactory.registerType(INT, TriggerFunctionTokenType.INT);
        TypeFactory.registerType(INT, TriggerFunctionTokenType.INTEGER);
        TypeFactory.registerType(SHORT, TriggerFunctionTokenType.SHORT);
        TypeFactory.registerType(LONG, TriggerFunctionTokenType.LONG);
        TypeFactory.registerType(FLOAT, TriggerFunctionTokenType.FLOAT);
        TypeFactory.registerType(DOUBLE, TriggerFunctionTokenType.DOUBLE);
        TypeFactory.registerType(BYTE, TriggerFunctionTokenType.BYTE);
        TypeFactory.registerType(BIGINTEGER, TriggerFunctionTokenType.BIGINT);
        TypeFactory.registerType(BIGINTEGER, TriggerFunctionTokenType.BIGINTEGER);
        TypeFactory.registerType(BOOLEAN, TriggerFunctionTokenType.BOOLEAN);
        TypeFactory.registerType(CHAR, TriggerFunctionTokenType.CHAR);
        TypeFactory.registerType(DATE, TriggerFunctionTokenType.DATE);
        TypeFactory.registerType(SQL_DATE, TriggerFunctionTokenType.SQL_DATE);
        TypeFactory.registerType(SQL_TIMESTAMP, TriggerFunctionTokenType.SQL_TIMESTAMP);
        TypeFactory.registerType(LIST, TriggerFunctionTokenType.LIST);
        TypeFactory.registerType(SET, TriggerFunctionTokenType.SET);
        TypeFactory.registerType(COLLECTION, TriggerFunctionTokenType.COLLECTION);
        TypeFactory.registerType(BLOCKING_QUEUE, TriggerFunctionTokenType.BLOCKING_QUEUE);
        TypeFactory.registerType(EVENT_QUEUE, TriggerFunctionTokenType.EVENT_QUEUE);
        TypeFactory.registerType(AUDIT_QUEUE, TriggerFunctionTokenType.AUDIT_QUEUE);
        TypeFactory.registerType(MESSAGE_QUEUE, TriggerFunctionTokenType.MESSAGE_QUEUE);
        TypeFactory.registerType(PROCESS_QUEUE, TriggerFunctionTokenType.PROCESS_QUEUE);
        TypeFactory.registerType(TABLE, TriggerFunctionTokenType.TABLE);
        TypeFactory.registerType(EVENT_TABLE, TriggerFunctionTokenType.EVENT_TABLE);
        TypeFactory.registerType(FILE_TABLE, TriggerFunctionTokenType.FILE_TABLE);
        TypeFactory.registerType(VIRTUAL_TABLE, TriggerFunctionTokenType.VIRTUAL_TABLE);
        TypeFactory.registerType(DIRECTORY, TriggerFunctionTokenType.DIRECTORY);
        TypeFactory.registerType(VIEW, TriggerFunctionTokenType.VIEW);
        TypeFactory.registerType(SOURCE_STREAM, TriggerFunctionTokenType.SOURCE_STREAM);
        TypeFactory.registerType(DATASPACE, TriggerFunctionTokenType.DATASPACE);
        TypeFactory.registerType(SERVICE, TriggerFunctionTokenType.SERVICE);
        TypeFactory.registerType(RUNTIME, TriggerFunctionTokenType.RUNTIME);
        LONG_NUMBER_PATTERN = Pattern.compile("[-+]?((0[lL]?)|([1-9]{1}(\\d+)?[lL]?)){1}");
        DOUBLE_NUMBER_PATTERN = Pattern.compile("[-+]?((0[fFdD])|(\\.\\d+([eE][-+]?\\d+)?[fFdD]?)|(0\\.\\d+([eE][-+]?\\d+)?[fFdD]?)|(([1-9]{1})(\\d+)?(\\.\\d+)?([eE][-+]?\\d+)?[fFdD]?)){1}");
        HEX_PATTERN = Pattern.compile("0x([0-9]|[a-f]|[A-F])+[lL]?");
    }
}

