/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.sef.evtrigger.function.types.AbstractType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import java.util.Date;

public class StringType
extends AbstractType<String> {
    StringType() {
        super(Types.STRING);
    }

    @Override
    public String convertValue(Object value, Type<?> type) throws ValueConversionException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            return TypeFactory.DATE.toString(value);
        }
        return value.toString();
    }

    @Override
    public void canConvert(Type<?> typeFrom) throws TypeConversionException {
        if (typeFrom.getType() == this.getType()) {
            return;
        }
        switch (typeFrom.getType()) {
            case STRING: 
            case INT: 
            case SHORT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BIGDECIMAL: 
            case BIGINT: 
            case BYTE: 
            case BOOLEAN: 
            case CHAR: 
            case DATE: 
            case SQL_DATE: 
            case SQL_TIMESTAMP: 
            case NULLTYPE: 
            case OBJECT: 
            case SEMANTIC_TYPE: 
            case ENUM: 
            case EVENT: 
            case VOID: {
                return;
            }
        }
        throw this.typeConversionException(typeFrom, this);
    }

    @Override
    public String sum(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        Object stringValue1 = this.convertValue(value1, (Type)type1);
        Object stringValue2 = this.convertValue(value2, (Type)type2);
        return (String)stringValue1 + (String)stringValue2;
    }

    @Override
    public void validateSum(Type<?> type) throws TypeConversionException {
        this.canConvert(type);
    }

    @Override
    protected String onEscapeValue(Object value) {
        return "'" + value.toString() + "'";
    }

    @Override
    public String getJavaClassName() {
        return String.class.getName();
    }

    @Override
    public String getDefaultInitializer(String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        return "new " + this.getJavaClassName() + "(\"" + defaultValue + "\")";
    }
}

