/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.sef.evtrigger.function.types.AbstractNumberType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;

public class ShortType
extends AbstractNumberType<Short> {
    ShortType() {
        super(Types.SHORT);
    }

    @Override
    public Short convertValue(Object value, Type<?> valueType) throws ValueConversionException {
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        try {
            return Short.valueOf(this.removeNumberSuffix(value.toString()));
        }
        catch (NumberFormatException exception) {
            throw this.valueConversionException(value, valueType, exception);
        }
    }

    @Override
    public Short onSum(Number value1, Number value2) throws ValueConversionException {
        return (short)((Short)value1 + (Short)value2);
    }

    @Override
    public Short onMinus(Number value1, Number value2) throws ValueConversionException {
        return (short)((Short)value1 - (Short)value2);
    }

    @Override
    public Short onMul(Number value1, Number value2) throws ValueConversionException {
        return (short)((Short)value1 * (Short)value2);
    }

    @Override
    public Short onDivide(Number value1, Number value2) throws ValueConversionException {
        return (short)((Short)value1 / (Short)value2);
    }

    @Override
    public Short onDegree(Number value1, Number value2) throws ValueConversionException {
        return new Double(Math.pow(value1.shortValue(), value2.doubleValue())).shortValue();
    }

    @Override
    public Short onNegative(Number value) throws ValueConversionException {
        return -((Short)value).shortValue();
    }

    @Override
    public String getJavaClassName() {
        return Short.class.getName();
    }

    @Override
    public String getDefaultInitializer(String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        return "new " + this.getJavaClassName() + "((short)" + defaultValue + ")";
    }
}

