/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.sef.evtrigger.function.types.AbstractType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import java.sql.Timestamp;
import java.util.Date;

public class SQLTimestampType
extends AbstractType<Timestamp> {
    SQLTimestampType() {
        super(Types.SQL_TIMESTAMP);
    }

    @Override
    public Timestamp convertValue(Object value, Type<?> valueType) throws ValueConversionException {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        try {
            return Timestamp.valueOf(value.toString());
        }
        catch (IllegalArgumentException exception) {
            throw this.valueConversionException(value, valueType, exception);
        }
    }

    @Override
    public void canConvert(Type<?> typeFrom) throws TypeConversionException {
        if (typeFrom.getType() == this.getType()) {
            return;
        }
        switch (typeFrom.getType()) {
            case NULLTYPE: 
            case STRING: 
            case SQL_TIMESTAMP: 
            case OBJECT: {
                return;
            }
        }
        throw this.typeConversionException(typeFrom, this);
    }

    @Override
    public boolean lessthan(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        if (value1 == null || value2 == null) {
            throw new ValueConversionException("Null values not allowed in '<' condition.");
        }
        Object timestamp1 = this.convertValue(value1, (Type)type1);
        Object date2 = this.convertValue(value2, (Type)type2);
        return ((Timestamp)timestamp1).getTime() < ((Timestamp)date2).getTime();
    }

    @Override
    public boolean greaterthan(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        if (value1 == null || value2 == null) {
            throw new ValueConversionException("Null values not allowed in '>' condition.");
        }
        Object timestamp1 = this.convertValue(value1, (Type)type1);
        Object timestamp2 = this.convertValue(value2, (Type)type2);
        return ((Timestamp)timestamp1).getTime() > ((Timestamp)timestamp2).getTime();
    }

    @Override
    public boolean lessthanOrEquals(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        if (value1 == null || value2 == null) {
            throw new ValueConversionException("Null values not allowed in '<= condition.");
        }
        Object timestamp1 = this.convertValue(value1, (Type)type1);
        Object timestamp2 = this.convertValue(value2, (Type)type2);
        return ((Timestamp)timestamp1).getTime() <= ((Timestamp)timestamp2).getTime();
    }

    @Override
    public boolean greaterthanOrEquals(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        if (value1 == null || value2 == null) {
            throw new ValueConversionException("Null values not allowed in '>=' condition.");
        }
        Object timestamp1 = this.convertValue(value1, (Type)type1);
        Object timestamp2 = this.convertValue(value2, (Type)type2);
        return ((Timestamp)timestamp1).getTime() >= ((Timestamp)timestamp2).getTime();
    }

    @Override
    public void validateLessthan(Type<?> type) throws TypeConversionException {
        this.canConvert(type);
    }

    @Override
    public void validateGreaterthan(Type<?> type) throws TypeConversionException {
        this.canConvert(type);
    }

    @Override
    public void validateLessthanOrEquals(Type<?> type) throws TypeConversionException {
        this.canConvert(type);
    }

    @Override
    public void validateGreaterthanOrEquals(Type<?> type) throws TypeConversionException {
        this.canConvert(type);
    }

    @Override
    protected String onEscapeValue(Object value) {
        if (value instanceof Date) {
            return "'" + this.toString(value) + "'";
        }
        return "'" + this.toString(value) + "'";
    }

    @Override
    protected String onToString(Object value) {
        return value.toString();
    }

    @Override
    public String getJavaClassName() {
        return Timestamp.class.getName();
    }

    @Override
    public String getDefaultInitializer(String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        return this.getJavaClassName() + ".valueOf(\"" + defaultValue + "\")";
    }
}

