/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.sef.evtrigger.function.types.AbstractType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import java.util.Date;

public class SQLDateType
extends AbstractType<java.sql.Date> {
    SQLDateType() {
        super(Types.SQL_DATE);
    }

    @Override
    public java.sql.Date convertValue(Object value, Type<?> valueType) throws ValueConversionException {
        if (value == null) {
            return null;
        }
        if (value instanceof java.sql.Date) {
            return (java.sql.Date)value;
        }
        try {
            return java.sql.Date.valueOf(value.toString());
        }
        catch (IllegalArgumentException exception) {
            throw this.valueConversionException(value, valueType, exception);
        }
    }

    @Override
    public void canConvert(Type<?> typeFrom) throws TypeConversionException {
        if (typeFrom.getType() == this.getType()) {
            return;
        }
        switch (typeFrom.getType()) {
            case NULLTYPE: 
            case STRING: 
            case SQL_DATE: 
            case OBJECT: {
                return;
            }
        }
        throw this.typeConversionException(typeFrom, this);
    }

    @Override
    public boolean lessthan(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        if (value1 == null || value2 == null) {
            throw new ValueConversionException("Null values not allowed in '<' condition.");
        }
        Object date1 = this.convertValue(value1, (Type)type1);
        Object date2 = this.convertValue(value2, (Type)type2);
        return ((Date)date1).getTime() < ((Date)date2).getTime();
    }

    @Override
    public boolean greaterthan(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        if (value1 == null || value2 == null) {
            throw new ValueConversionException("Null values not allowed in '>' condition.");
        }
        Object date1 = this.convertValue(value1, (Type)type1);
        Object date2 = this.convertValue(value2, (Type)type2);
        return ((Date)date1).getTime() > ((Date)date2).getTime();
    }

    @Override
    public boolean lessthanOrEquals(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        if (value1 == null || value2 == null) {
            throw new ValueConversionException("Null values not allowed in '<= condition.");
        }
        Object date1 = this.convertValue(value1, (Type)type1);
        Object date2 = this.convertValue(value2, (Type)type2);
        return ((Date)date1).getTime() <= ((Date)date2).getTime();
    }

    @Override
    public boolean greaterthanOrEquals(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        if (value1 == null || value2 == null) {
            throw new ValueConversionException("Null values not allowed in '>=' condition.");
        }
        Object date1 = this.convertValue(value1, (Type)type1);
        Object date2 = this.convertValue(value2, (Type)type2);
        return ((Date)date1).getTime() >= ((Date)date2).getTime();
    }

    @Override
    public void validateLessthan(Type<?> type) throws TypeConversionException {
        this.canConvert(type);
    }

    @Override
    public void validateGreaterthan(Type<?> type) throws TypeConversionException {
        this.canConvert(type);
    }

    @Override
    public void validateLessthanOrEquals(Type<?> type) throws TypeConversionException {
        this.canConvert(type);
    }

    @Override
    public void validateGreaterthanOrEquals(Type<?> type) throws TypeConversionException {
        this.canConvert(type);
    }

    @Override
    protected String onEscapeValue(Object value) {
        if (value instanceof Date) {
            return "'" + this.toString(value) + "'";
        }
        return "'" + this.toString(value) + "'";
    }

    @Override
    protected String onToString(Object value) {
        return value.toString();
    }

    @Override
    public String getJavaClassName() {
        return java.sql.Date.class.getName();
    }

    @Override
    public String getDefaultInitializer(String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        return this.getJavaClassName() + ".valueOf(\"" + defaultValue + "\")";
    }
}

