/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.sef.evtrigger.function.types.AbstractNumberType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import java.sql.Timestamp;
import java.util.Date;

public class LongType
extends AbstractNumberType<Long> {
    LongType() {
        super(Types.LONG);
    }

    @Override
    public void canConvert(Type<?> typeFrom) throws TypeConversionException {
        if (typeFrom.getType() == this.getType()) {
            return;
        }
        switch (typeFrom.getType()) {
            case DATE: 
            case SQL_DATE: 
            case SQL_TIMESTAMP: {
                return;
            }
        }
        super.canConvert(typeFrom);
    }

    @Override
    public Long convertValue(Object value, Type<?> valueType) throws ValueConversionException {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof java.sql.Date) {
            return ((java.sql.Date)value).getTime();
        }
        if (value instanceof Timestamp) {
            return ((Timestamp)value).getTime();
        }
        try {
            return Long.valueOf(this.removeNumberSuffix(value.toString()));
        }
        catch (NumberFormatException exception) {
            throw this.valueConversionException(value, valueType, exception);
        }
    }

    @Override
    public Long onSum(Number value1, Number value2) throws ValueConversionException {
        return (Long)value1 + (Long)value2;
    }

    @Override
    public Long onMinus(Number value1, Number value2) throws ValueConversionException {
        return (Long)value1 - (Long)value2;
    }

    @Override
    public Long onMul(Number value1, Number value2) throws ValueConversionException {
        return (Long)value1 * (Long)value2;
    }

    @Override
    public Long onDivide(Number value1, Number value2) throws ValueConversionException {
        return (Long)value1 / (Long)value2;
    }

    @Override
    public Long onDegree(Number value1, Number value2) throws ValueConversionException {
        return new Double(Math.pow(value1.doubleValue(), value2.doubleValue())).longValue();
    }

    @Override
    public Long onNegative(Number value) throws ValueConversionException {
        return -((Long)value).longValue();
    }

    @Override
    public String getJavaClassName() {
        return Long.class.getName();
    }

    @Override
    public String getDefaultInitializer(String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        return "new " + this.getJavaClassName() + "((long)" + this.onEscapeValue(defaultValue) + ")";
    }

    @Override
    protected String onEscapeValue(Object value) {
        if (value instanceof String && ((String)value).endsWith("l") || ((String)value).endsWith("L")) {
            return (String)value;
        }
        return value.toString() + "L";
    }
}

