/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.sef.evtrigger.function.types.AbstractNumberType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;

public class IntType
extends AbstractNumberType<Integer> {
    IntType() {
        super(Types.INT);
    }

    @Override
    public Integer convertValue(Object value, Type<?> valueType) throws ValueConversionException {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.valueOf(this.removeNumberSuffix(value.toString()));
        }
        catch (NumberFormatException exception) {
            throw this.valueConversionException(value, valueType, exception);
        }
    }

    @Override
    public Integer onSum(Number value1, Number value2) throws ValueConversionException {
        return (Integer)value1 + (Integer)value2;
    }

    @Override
    public Integer onMinus(Number value1, Number value2) throws ValueConversionException {
        return (Integer)value1 - (Integer)value2;
    }

    @Override
    public Integer onMul(Number value1, Number value2) throws ValueConversionException {
        return (Integer)value1 * (Integer)value2;
    }

    @Override
    public Integer onDivide(Number value1, Number value2) throws ValueConversionException {
        return (Integer)value1 / (Integer)value2;
    }

    @Override
    public Integer onDegree(Number value1, Number value2) throws ValueConversionException {
        return new Double(Math.pow(value1.doubleValue(), value2.doubleValue())).intValue();
    }

    @Override
    public Integer onNegative(Number value) throws ValueConversionException {
        return -((Integer)value).intValue();
    }

    @Override
    public String getJavaClassName() {
        return Integer.class.getName();
    }

    @Override
    public String getDefaultInitializer(String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        return "new " + this.getJavaClassName() + "((int)" + defaultValue + ")";
    }
}

