/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.sef.evtrigger.function.types.AbstractNumberType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;

public class FloatType
extends AbstractNumberType<Float> {
    FloatType() {
        super(Types.FLOAT);
    }

    @Override
    public Float convertValue(Object value, Type<?> valueType) throws ValueConversionException {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        try {
            return Float.valueOf(this.removeNumberSuffix(value.toString()));
        }
        catch (NumberFormatException exception) {
            throw this.valueConversionException(value, valueType, exception);
        }
    }

    @Override
    public Float onSum(Number value1, Number value2) throws ValueConversionException {
        return Float.valueOf(((Float)value1).floatValue() + ((Float)value2).floatValue());
    }

    @Override
    public Float onMinus(Number value1, Number value2) throws ValueConversionException {
        return Float.valueOf(((Float)value1).floatValue() - ((Float)value2).floatValue());
    }

    @Override
    public Float onMul(Number value1, Number value2) throws ValueConversionException {
        return Float.valueOf(((Float)value1).floatValue() * ((Float)value2).floatValue());
    }

    @Override
    public Float onDivide(Number value1, Number value2) throws ValueConversionException {
        return Float.valueOf(((Float)value1).floatValue() / ((Float)value2).floatValue());
    }

    @Override
    public Float onDegree(Number value1, Number value2) throws ValueConversionException {
        return Float.valueOf(new Double(Math.pow(value1.doubleValue(), value2.doubleValue())).floatValue());
    }

    @Override
    public Float onNegative(Number value) throws ValueConversionException {
        return Float.valueOf(-((Float)value).floatValue());
    }

    @Override
    public String getJavaClassName() {
        return Float.class.getName();
    }

    @Override
    public String getDefaultInitializer(String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        return "new " + this.getJavaClassName() + "((float)" + this.onEscapeValue(defaultValue) + ")";
    }

    @Override
    protected String onEscapeValue(Object value) {
        if (value instanceof String && ((String)value).endsWith("f") || ((String)value).endsWith("F")) {
            return (String)value;
        }
        return value.toString() + "F";
    }
}

