/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sef.evtrigger.function.SemanticTypeLookupContext;
import com.streamscape.sef.evtrigger.function.types.AbstractObjectType;
import com.streamscape.sef.evtrigger.function.types.ObjectType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;

public class EventType
extends AbstractObjectType<ImmutableEventDatagram> {
    private String eventId;

    protected EventType() {
        super(Types.EVENT);
        this.setSemanticTypeClassName(ImmutableEventDatagram.class.getName());
    }

    @Override
    public ImmutableEventDatagram convertValue(Object value, Type<?> valueType) throws ValueConversionException {
        if (!this.canConvertInternal(valueType)) {
            throw this.valueConversionException(value, valueType, null);
        }
        return (ImmutableEventDatagram)value;
    }

    @Override
    public void canConvert(Type<?> fromType) throws TypeConversionException {
        if (!this.canConvertInternal(fromType)) {
            throw this.typeConversionException(fromType, this);
        }
    }

    private boolean canConvertInternal(Type<?> fromType) {
        if (fromType.getType() == Types.NULLTYPE) {
            return true;
        }
        if (fromType.getType() == Types.OBJECT) {
            Type<?> realFromObjectType = ((ObjectType)fromType).getRealType();
            if (realFromObjectType == null || realFromObjectType.getType() != Types.EVENT) {
                return false;
            }
            fromType = realFromObjectType;
        } else if (fromType.getType() != Types.EVENT) {
            return false;
        }
        EventType fromEventType = (EventType)fromType;
        this.setSemanticTypeClassName(fromEventType.getSemanticTypeClassName());
        this.setSemanticTypeName(fromEventType.getSemanticTypeName());
        this.setEventId(this.eventId != null ? this.eventId : fromEventType.getEventId());
        return true;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getEventId() {
        return this.eventId;
    }

    @Override
    public boolean equals(Type<?> toType) {
        return this == toType || super.equals(toType) && (this.eventId == ((EventType)toType).getEventId() || this.eventId != null && this.eventId.equals(((EventType)toType).getEventId()));
    }

    @Override
    public String getName() {
        Object name = super.getName();
        if (this.eventId != null) {
            name = (String)name + "[" + this.eventId + "]";
        }
        return name;
    }

    public void resolveEventType(SemanticTypeLookupContext context) throws Exception {
        if (this.getEventId() == null || this.getEventId().length() == 0) {
            throw new Exception("EventId is null or empty.");
        }
        EventType eventType = TypeFactory.createEventType(context, this.getEventId());
        this.setSemanticTypeClassName(eventType.getSemanticTypeClassName());
        this.setSemanticTypeName(eventType.getSemanticTypeName());
    }
}

