/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.Trace;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.runtime.mf.operation.edl.annotations.Enum;
import com.streamscape.sef.evtrigger.function.types.AbstractObjectType;
import com.streamscape.sef.evtrigger.function.types.ObjectType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class EnumType
extends AbstractObjectType<Object> {
    private Class<?> enumClass;

    protected EnumType() {
        super(Types.ENUM);
    }

    @Override
    public Object convertValue(Object value, Type<?> valueType) throws ValueConversionException {
        if (value == null) {
            return null;
        }
        try {
            this.initEnumClass();
        }
        catch (ClassNotFoundException exception) {
            throw this.valueConversionException(value, valueType, exception);
        }
        if (this.isUserDefinedEnum()) {
            if (value instanceof String) {
                String enumValue = EnumType.getEnumWithoutType((String)value);
                for (Field field : this.enumClass.getDeclaredFields()) {
                    if (!Modifier.isStatic(field.getModifiers()) || !field.getName().equals(enumValue)) continue;
                    return value;
                }
            }
        } else {
            if (value instanceof String) {
                String enumValue = EnumType.getEnumWithoutType((String)value);
                try {
                    return java.lang.Enum.valueOf(this.enumClass, enumValue);
                }
                catch (Exception e) {
                    throw this.valueConversionException(value, valueType, e);
                }
            }
            if (this.enumClass == value.getClass() || this.enumClass.isAssignableFrom(value.getClass())) {
                return value;
            }
        }
        throw this.valueConversionException(value, valueType, null);
    }

    @Override
    public void canConvert(Type<?> fromType) throws TypeConversionException {
        if (!this.canConvertInternal(fromType)) {
            throw this.typeConversionException(fromType, this);
        }
    }

    private boolean canConvertInternal(Type<?> fromType) {
        ObjectType fromObjectType;
        Type<?> realFromObjectType;
        if (fromType == null) {
            return false;
        }
        return !(fromType.getType() == Types.OBJECT ? (realFromObjectType = (fromObjectType = (ObjectType)fromType).getRealType()) != null && (realFromObjectType.getType() != Types.ENUM || !this.getSemanticTypeClassName().equals(((AbstractObjectType)realFromObjectType).getSemanticTypeClassName())) : fromType.getType() != Types.ENUM || !this.getSemanticTypeClassName().equals(((AbstractObjectType)fromType).getSemanticTypeClassName()));
    }

    @Override
    public String getDefaultInitializer(String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        if (this.getSemanticTypeClassName() != null) {
            return this.getSemanticTypeClassName() + "." + EnumType.getEnumWithoutType(defaultValue);
        }
        return defaultValue;
    }

    @Override
    public String getDefaultObjectInitializer(String defaultValue) {
        return this.getDefaultInitializer(defaultValue);
    }

    public static String getEnumWithoutType(String value) {
        int pos;
        if (value != null && (pos = value.indexOf(46)) + 1 < value.length()) {
            value = value.substring(pos + 1);
        }
        return value;
    }

    private void initEnumClass() throws ClassNotFoundException {
        if (this.enumClass == null) {
            this.enumClass = RuntimeState.isActive() ? ClassUtils.loadClass(this.getSemanticTypeClassName(), RuntimeContext.getInstance().getSystemClassLoaderChain()) : ClassUtils.loadClass(this.getSemanticTypeClassName(), Thread.currentThread().getContextClassLoader());
        }
    }

    public static boolean isEnum(Class<?> clazz) {
        return clazz.isEnum() || EnumType.isUserDefinedEnum(clazz);
    }

    public static boolean isUserDefinedEnum(Class<?> clazz) {
        return clazz.getAnnotation(Enum.class) != null;
    }

    public boolean isUserDefinedEnum() {
        try {
            this.initEnumClass();
            return EnumType.isUserDefinedEnum(this.enumClass);
        }
        catch (ClassNotFoundException e) {
            Trace.logError(this, "Failed to load enum class. Cause: " + e.getMessage());
            return false;
        }
    }

    @Override
    public String getJavaClassName() {
        if (this.isUserDefinedEnum()) {
            return String.class.getName();
        }
        return this.getSemanticTypeClassName();
    }

    public static boolean isValueFromEnum(Class<?> clazz, String value) {
        if (clazz.isEnum()) {
            try {
                java.lang.Enum.valueOf(clazz, value);
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        if (EnumType.isUserDefinedEnum(clazz)) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !field.getName().equals(value)) continue;
                return true;
            }
        }
        return false;
    }
}

