/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.sef.evtrigger.function.types.AbstractNumberType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;

public class DoubleType
extends AbstractNumberType<Double> {
    DoubleType() {
        super(Types.DOUBLE);
    }

    @Override
    public Double convertValue(Object value, Type<?> valueType) throws ValueConversionException {
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        try {
            return Double.valueOf(this.removeNumberSuffix(value.toString()));
        }
        catch (NumberFormatException exception) {
            throw this.valueConversionException(value, valueType, exception);
        }
    }

    @Override
    public Double onSum(Number value1, Number value2) throws ValueConversionException {
        return (Double)value1 + (Double)value2;
    }

    @Override
    public Double onMinus(Number value1, Number value2) throws ValueConversionException {
        return (Double)value1 - (Double)value2;
    }

    @Override
    public Double onMul(Number value1, Number value2) throws ValueConversionException {
        return (Double)value1 * (Double)value2;
    }

    @Override
    public Double onDivide(Number value1, Number value2) throws ValueConversionException {
        return (Double)value1 / (Double)value2;
    }

    @Override
    public Double onDegree(Number value1, Number value2) throws ValueConversionException {
        return Math.pow(value1.doubleValue(), value2.doubleValue());
    }

    @Override
    public Double onNegative(Number value) throws ValueConversionException {
        return -((Double)value).doubleValue();
    }

    @Override
    public String getJavaClassName() {
        return Double.class.getName();
    }

    @Override
    public String getDefaultInitializer(String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        return "new " + this.getJavaClassName() + "((double)" + this.onEscapeValue(defaultValue) + ")";
    }

    @Override
    protected String onEscapeValue(Object value) {
        if (value instanceof String && ((String)value).endsWith("d") || ((String)value).endsWith("D")) {
            return (String)value;
        }
        return value.toString() + "D";
    }
}

