/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.sef.evtrigger.function.types.AbstractType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateType
extends AbstractType<Date> {
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    DateType() {
        super(Types.DATE);
    }

    @Override
    public Date convertValue(Object value, Type<?> valueType) throws ValueConversionException {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        try {
            return new SimpleDateFormat(DEFAULT_DATE_FORMAT).parse(value.toString());
        }
        catch (ParseException exception) {
            throw this.valueConversionException(value, valueType, exception);
        }
    }

    @Override
    public void canConvert(Type<?> typeFrom) throws TypeConversionException {
        if (typeFrom.getType() == this.getType()) {
            return;
        }
        switch (typeFrom.getType()) {
            case NULLTYPE: 
            case STRING: 
            case DATE: 
            case OBJECT: {
                return;
            }
        }
        throw this.typeConversionException(typeFrom, this);
    }

    @Override
    public boolean lessthan(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        if (value1 == null || value2 == null) {
            throw new ValueConversionException("Null values not allowed in '<' condition.");
        }
        Object date1 = this.convertValue(value1, (Type)type1);
        Object date2 = this.convertValue(value2, (Type)type2);
        return ((Date)date1).getTime() < ((Date)date2).getTime();
    }

    @Override
    public boolean greaterthan(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        if (value1 == null || value2 == null) {
            throw new ValueConversionException("Null values not allowed in '>' condition.");
        }
        Object date1 = this.convertValue(value1, (Type)type1);
        Object date2 = this.convertValue(value2, (Type)type2);
        return ((Date)date1).getTime() > ((Date)date2).getTime();
    }

    @Override
    public boolean lessthanOrEquals(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        if (value1 == null || value2 == null) {
            throw new ValueConversionException("Null values not allowed in '<= condition.");
        }
        Object date1 = this.convertValue(value1, (Type)type1);
        Object date2 = this.convertValue(value2, (Type)type2);
        return ((Date)date1).getTime() <= ((Date)date2).getTime();
    }

    @Override
    public boolean greaterthanOrEquals(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        if (value1 == null || value2 == null) {
            throw new ValueConversionException("Null values not allowed in '>=' condition.");
        }
        Object date1 = this.convertValue(value1, (Type)type1);
        Object date2 = this.convertValue(value2, (Type)type2);
        return ((Date)date1).getTime() >= ((Date)date2).getTime();
    }

    @Override
    public void validateLessthan(Type<?> type) throws TypeConversionException {
        this.canConvert(type);
    }

    @Override
    public void validateGreaterthan(Type<?> type) throws TypeConversionException {
        this.canConvert(type);
    }

    @Override
    public void validateLessthanOrEquals(Type<?> type) throws TypeConversionException {
        this.canConvert(type);
    }

    @Override
    public void validateGreaterthanOrEquals(Type<?> type) throws TypeConversionException {
        this.canConvert(type);
    }

    @Override
    protected String onEscapeValue(Object value) {
        if (value instanceof Date) {
            return "'" + this.toString(value) + "'";
        }
        return "'" + this.toString(value) + "'";
    }

    @Override
    protected String onToString(Object value) {
        if (value instanceof Date) {
            return new SimpleDateFormat(DEFAULT_DATE_FORMAT).format((Date)value);
        }
        return value.toString();
    }

    @Override
    public String getJavaClassName() {
        return Date.class.getName();
    }

    @Override
    public String getDefaultInitializer(String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        return "new java.text.SimpleDateFormat(\"yyyy-MM-dd HH:mm:ss\").parse(\"" + defaultValue + "\")";
    }
}

