/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.cli.ds.DataCollection;
import com.streamscape.cli.ds.collection.AuditQueue;
import com.streamscape.cli.ds.collection.BlockingQueue;
import com.streamscape.cli.ds.collection.DirectoryTable;
import com.streamscape.cli.ds.collection.EventQueue;
import com.streamscape.cli.ds.collection.EventTable;
import com.streamscape.cli.ds.collection.FileTable;
import com.streamscape.cli.ds.collection.MessageQueue;
import com.streamscape.cli.ds.collection.ProcessQueue;
import com.streamscape.cli.ds.collection.SourceStream;
import com.streamscape.cli.ds.collection.Table;
import com.streamscape.cli.ds.collection.View;
import com.streamscape.cli.ds.collection.VirtualTable;
import com.streamscape.sef.evtrigger.function.types.AbstractObjectType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;

abstract class DataCollectionType<T extends DataCollection>
extends AbstractObjectType<T> {
    private Class<?> clazz;

    protected DataCollectionType(Types type, Class<? extends DataCollection> clazz) {
        super(type);
        this.clazz = clazz;
        this.setSemanticTypeClassName(clazz.getName());
        this.setSemanticTypeName(clazz.getSimpleName());
    }

    @Override
    public T convertValue(Object value, Type<?> valueType) throws ValueConversionException {
        if (value == null) {
            return null;
        }
        if (this.clazz.isAssignableFrom(value.getClass())) {
            return (T)((DataCollection)value);
        }
        throw this.valueConversionException(value, valueType, null);
    }

    @Override
    public void canConvert(Type<?> fromType) throws TypeConversionException {
        if (!this.canConvertInternal(fromType)) {
            throw this.typeConversionException(fromType, this);
        }
    }

    private boolean canConvertInternal(Type<?> fromType) {
        if (fromType.getType() == Types.NULLTYPE) {
            return true;
        }
        return fromType.getType() == Types.MAP || fromType.getType() == Types.QUEUE || fromType.getType() == Types.OBJECT || fromType instanceof DataCollectionType;
    }

    @Override
    protected String onEscapeValue(Object value) {
        return value.toString();
    }

    static class DataspaceCollectionType
    extends DataCollectionType<DataCollection> {
        protected DataspaceCollectionType() {
            super(Types.DATASPACE_COLLECTION, DataCollection.class);
        }
    }

    static class SourceStreamType
    extends DataCollectionType<SourceStream> {
        protected SourceStreamType() {
            super(Types.SOURCE_STREAM, SourceStream.class);
        }
    }

    static class ViewType
    extends DataCollectionType<View> {
        protected ViewType() {
            super(Types.VIEW, View.class);
        }
    }

    static class DirectoryType
    extends DataCollectionType<DirectoryTable> {
        protected DirectoryType() {
            super(Types.DIRECTORY, DirectoryTable.class);
        }
    }

    static class VirtualTableType
    extends DataCollectionType<VirtualTable> {
        protected VirtualTableType() {
            super(Types.VIRTUAL_TABLE, VirtualTable.class);
        }
    }

    static class FileTableType
    extends DataCollectionType<FileTable> {
        protected FileTableType() {
            super(Types.FILE_TABLE, FileTable.class);
        }
    }

    static class EventTableType
    extends DataCollectionType<EventTable> {
        protected EventTableType() {
            super(Types.EVENT_TABLE, EventTable.class);
        }
    }

    static class TableType
    extends DataCollectionType<Table> {
        protected TableType() {
            super(Types.TABLE, Table.class);
        }
    }

    static class ProcessQueueType
    extends DataCollectionType<ProcessQueue> {
        protected ProcessQueueType() {
            super(Types.PROCESS_QUEUE, ProcessQueue.class);
        }
    }

    static class MessageQueueType
    extends DataCollectionType<MessageQueue> {
        protected MessageQueueType() {
            super(Types.MESSAGE_QUEUE, MessageQueue.class);
        }
    }

    static class AuditQueueType
    extends DataCollectionType<AuditQueue> {
        protected AuditQueueType() {
            super(Types.AUDIT_QUEUE, AuditQueue.class);
        }
    }

    static class EventQueueType
    extends DataCollectionType<EventQueue> {
        protected EventQueueType() {
            super(Types.EVENT_QUEUE, EventQueue.class);
        }
    }

    static class BlockingQueueType
    extends DataCollectionType<BlockingQueue> {
        protected BlockingQueueType() {
            super(Types.BLOCKING_QUEUE, BlockingQueue.class);
        }
    }
}

