/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.sef.evtrigger.function.types.AbstractType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;

public class CharType
extends AbstractType<Character> {
    CharType() {
        super(Types.CHAR);
    }

    @Override
    public Character convertValue(Object value, Type<?> valueType) throws ValueConversionException {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        String stringValue = value.toString();
        if (stringValue.length() == 1) {
            return Character.valueOf(stringValue.charAt(0));
        }
        throw this.valueConversionException(value, valueType, null);
    }

    @Override
    public void canConvert(Type<?> typeFrom) throws TypeConversionException {
        if (typeFrom.getType() == this.getType()) {
            return;
        }
        switch (typeFrom.getType()) {
            case CHAR: 
            case STRING: 
            case NULLTYPE: 
            case OBJECT: {
                return;
            }
        }
        throw this.typeConversionException(typeFrom, this);
    }

    @Override
    protected String onEscapeValue(Object value) {
        return "'" + value.toString() + "'";
    }

    @Override
    public String getJavaClassName() {
        return Character.class.getName();
    }

    @Override
    public String getDefaultInitializer(String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        return this.getJavaClassName() + ".valueOf(\"" + defaultValue + "\")";
    }
}

