/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.sef.evtrigger.function.types.AbstractNumberType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;

public class ByteType
extends AbstractNumberType<Byte> {
    ByteType() {
        super(Types.BYTE);
    }

    @Override
    public Byte convertValue(Object value, Type<?> valueType) throws ValueConversionException {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        try {
            return Byte.valueOf(this.removeNumberSuffix(value.toString()));
        }
        catch (NumberFormatException exception) {
            throw this.valueConversionException(value, valueType, exception);
        }
    }

    @Override
    public Byte onSum(Number value1, Number value2) throws ValueConversionException {
        return (byte)((Byte)value1 + (Byte)value2);
    }

    @Override
    public Byte onMinus(Number value1, Number value2) throws ValueConversionException {
        return (byte)((Byte)value1 - (Byte)value2);
    }

    @Override
    public Byte onMul(Number value1, Number value2) throws ValueConversionException {
        return (byte)((Byte)value1 * (Byte)value2);
    }

    @Override
    public Byte onDivide(Number value1, Number value2) throws ValueConversionException {
        return (byte)((Byte)value1 / (Byte)value2);
    }

    @Override
    public Byte onDegree(Number value1, Number value2) throws ValueConversionException {
        return new Double(Math.pow(value1.doubleValue(), value2.doubleValue())).byteValue();
    }

    @Override
    public Byte onNegative(Number value) throws ValueConversionException {
        return -((Byte)value).byteValue();
    }

    @Override
    public String getJavaClassName() {
        return Byte.class.getName();
    }

    @Override
    public String getDefaultInitializer(String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        return "new " + this.getJavaClassName() + "((byte)" + defaultValue + ")";
    }
}

