/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.sef.evtrigger.function.types.AbstractType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;

public class BooleanType
extends AbstractType<Boolean> {
    BooleanType() {
        super(Types.BOOLEAN);
    }

    @Override
    public Boolean convertValue(Object value, Type<?> valueType) throws ValueConversionException {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String stringValue = value.toString();
        if (stringValue.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (stringValue.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        throw this.valueConversionException(value, valueType, null);
    }

    @Override
    public void canConvert(Type<?> typeFrom) throws TypeConversionException {
        if (typeFrom.getType() == this.getType()) {
            return;
        }
        switch (typeFrom.getType()) {
            case BOOLEAN: 
            case NULLTYPE: 
            case OBJECT: {
                return;
            }
        }
        throw this.typeConversionException(typeFrom, this);
    }

    @Override
    protected String onEscapeValue(Object value) {
        return value.toString();
    }

    @Override
    public String getJavaClassName() {
        return Boolean.class.getName();
    }

    @Override
    public String getDefaultInitializer(String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        return "new " + this.getJavaClassName() + "(" + defaultValue + ")";
    }
}

