/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.sef.evtrigger.function.types.AbstractNumberType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import java.math.BigInteger;

public class BigIntegerType
extends AbstractNumberType<BigInteger> {
    BigIntegerType() {
        super(Types.BIGINT);
    }

    @Override
    public BigInteger convertValue(Object value, Type<?> valueType) throws ValueConversionException {
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Number) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        try {
            return new BigInteger(this.removeNumberSuffix(value.toString()));
        }
        catch (NumberFormatException exception) {
            throw this.valueConversionException(value, valueType, exception);
        }
    }

    @Override
    public BigInteger onSum(Number value1, Number value2) throws ValueConversionException {
        return ((BigInteger)value1).add((BigInteger)value2);
    }

    @Override
    public BigInteger onMinus(Number value1, Number value2) throws ValueConversionException {
        return ((BigInteger)value1).add(((BigInteger)value2).negate());
    }

    @Override
    public BigInteger onMul(Number value1, Number value2) throws ValueConversionException {
        return ((BigInteger)value1).multiply((BigInteger)value2);
    }

    @Override
    public BigInteger onDivide(Number value1, Number value2) throws ValueConversionException {
        return ((BigInteger)value1).divide((BigInteger)value2);
    }

    @Override
    public BigInteger onDegree(Number value1, Number value2) throws ValueConversionException {
        return ((BigInteger)value1).pow(value2.intValue());
    }

    @Override
    public BigInteger onNegative(Number value) throws ValueConversionException {
        return ((BigInteger)value).negate();
    }

    @Override
    public String getJavaClassName() {
        return BigInteger.class.getName();
    }

    @Override
    public String getDefaultInitializer(String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        return "new " + this.getJavaClassName() + "(\"" + defaultValue + "\")";
    }
}

