/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.sef.evtrigger.function.types.AbstractNumberType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

class BigDecimalType
extends AbstractNumberType<BigDecimal> {
    private int scale = 0;
    private MathContext mathContext = null;

    BigDecimalType() {
        this(128, 0);
        this.mathContext = null;
    }

    BigDecimalType(int precision) {
        this(precision, 0);
    }

    BigDecimalType(int precision, int scale) {
        super(Types.BIGDECIMAL);
        this.mathContext = new MathContext(precision);
        this.scale = scale;
    }

    @Override
    public BigDecimal convertValue(Object value, Type<?> valueType) throws ValueConversionException {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return this.applyPrecisionAndScale((BigDecimal)value);
        }
        if (value instanceof Number) {
            return this.applyPrecisionAndScale(new BigDecimal(((Number)value).doubleValue()));
        }
        try {
            return this.applyPrecisionAndScale(new BigDecimal(this.removeNumberSuffix(value.toString())));
        }
        catch (NumberFormatException exception) {
            throw this.valueConversionException(value, valueType, exception);
        }
    }

    private BigDecimal applyPrecisionAndScale(BigDecimal value) {
        if (value != null && this.mathContext != null) {
            value = value.round(this.mathContext);
            value = value.setScale(this.scale, RoundingMode.HALF_UP);
        }
        return value;
    }

    @Override
    public BigDecimal onSum(Number value1, Number value2) throws ValueConversionException {
        return ((BigDecimal)value1).add((BigDecimal)value2);
    }

    @Override
    public BigDecimal onMinus(Number value1, Number value2) throws ValueConversionException {
        return ((BigDecimal)value1).add(((BigDecimal)value2).negate());
    }

    @Override
    public BigDecimal onMul(Number value1, Number value2) throws ValueConversionException {
        return ((BigDecimal)value1).multiply((BigDecimal)value2);
    }

    @Override
    public BigDecimal onDivide(Number value1, Number value2) throws ValueConversionException {
        return ((BigDecimal)value1).divide((BigDecimal)value2);
    }

    @Override
    public BigDecimal onDegree(Number value1, Number value2) throws ValueConversionException {
        return ((BigDecimal)value1).pow(value2.intValue());
    }

    @Override
    public BigDecimal onNegative(Number value) throws ValueConversionException {
        return ((BigDecimal)value).negate();
    }

    @Override
    public String getJavaClassName() {
        return BigDecimal.class.getName();
    }

    @Override
    public String getName() {
        Object name = super.getName();
        if (this.mathContext != null) {
            name = (String)name + "(" + this.mathContext.getPrecision() + ", " + this.scale + ")";
        }
        return name;
    }

    @Override
    public String getDefaultInitializer(String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        return "new " + this.getJavaClassName() + "(\"" + defaultValue + "\")";
    }
}

