/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.sef.evtrigger.function.TriggerFunctionException;
import com.streamscape.sef.evtrigger.function.types.AbstractType;
import com.streamscape.sef.evtrigger.function.types.ObjectType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import java.lang.reflect.Array;

public class ArrayType
extends AbstractType<Object[]> {
    private Type<?> elementType;

    ArrayType(Type<?> elementType) {
        super(Types.ARRAY);
        this.elementType = elementType;
    }

    @Override
    public boolean equals(Type<?> toType) {
        return this.getType() == toType.getType() && this.elementType.equals(((ArrayType)toType).getElementType());
    }

    @Override
    public Object[] convertValue(Object value, Type<?> valueType) throws ValueConversionException {
        if (value == null) {
            return null;
        }
        if (this.equals(valueType)) {
            return this.convertValueToObjectArray(value, valueType);
        }
        if (valueType.getType() == Types.ARRAY && this.getElementType().getType() == Types.OBJECT) {
            return this.convertValueToObjectArray(value, valueType);
        }
        if (valueType.getType() == Types.ARRAY && ((ArrayType)valueType).getElementType().getType() == Types.OBJECT) {
            Object[] valueArray;
            for (Object v : valueArray = (Object[])value) {
                if (v == null) continue;
                this.elementType.convertValue(v, ((ArrayType)valueType).getElementType());
            }
            return valueArray;
        }
        if (valueType.getType() == Types.OBJECT && value.getClass().isArray()) {
            Object[] valueArray = (Object[])value;
            Type<Object> valueTypeReal = ((ObjectType)valueType).getRealType();
            if (valueTypeReal != null && valueTypeReal instanceof ArrayType) {
                valueTypeReal = ((ArrayType)valueTypeReal).getElementType();
            }
            if (valueTypeReal != null) {
                try {
                    this.elementType.canConvert(valueTypeReal);
                }
                catch (TypeConversionException exception) {
                    throw new ValueConversionException(exception.getMessage());
                }
            } else {
                valueTypeReal = TypeFactory.createObjectType();
            }
            for (Object v : valueArray) {
                this.elementType.convertValue(v, valueTypeReal);
            }
            return valueArray;
        }
        throw this.valueConversionException(value, valueType, null);
    }

    private Object[] convertValueToObjectArray(Object value, Type<?> valueType) throws ValueConversionException {
        if (value == null) {
            return null;
        }
        if (!value.getClass().isArray()) {
            throw this.valueConversionException(value, valueType, null);
        }
        Class<?> valueElementType = value.getClass().getComponentType();
        if (!valueElementType.isPrimitive()) {
            return (Object[])value;
        }
        Class<?> wrappedElementType = TypeFactory.wrapPrimitive(valueElementType);
        if (wrappedElementType == null) {
            throw this.valueConversionException(value, valueType, null);
        }
        Object[] result = (Object[])Array.newInstance(wrappedElementType, Array.getLength(value));
        for (int i = 0; i < Array.getLength(value); ++i) {
            result[i] = this.elementType.convertValue(Array.get(value, i), ((ArrayType)valueType).getElementType());
        }
        return result;
    }

    @Override
    public void canConvert(Type<?> fromType) throws TypeConversionException {
        if (fromType == TypeFactory.NULLTYPE) {
            return;
        }
        if (this.equals(fromType)) {
            return;
        }
        if (this.equals(fromType) || fromType.getType() == Types.ARRAY && this.getElementType().getType() == Types.OBJECT || fromType.getType() == Types.OBJECT) {
            return;
        }
        throw this.typeConversionException(fromType, this);
    }

    public Type<?> getElementType() {
        return this.elementType;
    }

    @Override
    public String getName() {
        return this.elementType.getName() + "[]";
    }

    @Override
    public void validateIterate(Type<?> type) throws TriggerFunctionException {
        if (this.elementType.getType() == Types.OBJECT || type.getType() == Types.OBJECT) {
            return;
        }
        if (!this.elementType.equals(type)) {
            throw new TriggerFunctionException("Failed to iterate array of type '" + this.elementType.getName() + "' with variable of type '" + String.valueOf(type) + "'.");
        }
    }

    @Override
    protected String onEscapeValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (value.getClass().isArray()) {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            for (int i = 0; i < ((Object[])value).length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.elementType.escapeValue(((Object[])value)[i]));
            }
            builder.append("}");
            return builder.toString();
        }
        return value.toString();
    }

    @Override
    public Object clone() {
        ArrayType result = (ArrayType)super.clone();
        if (result.elementType != null) {
            result.elementType = (Type)result.elementType.clone();
        }
        return result;
    }

    @Override
    public String getJavaClassName() {
        if (this.elementType != null && this.elementType.getJavaClassName() != null) {
            return "[L" + this.elementType.getJavaClassName() + ";";
        }
        return null;
    }
}

