/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sef.evtrigger.function.TriggerFunctionException;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;

public abstract class AbstractType<T>
extends CloneableDataObject
implements Type<T> {
    private Types type;

    AbstractType(Types type) {
        this.type = type;
    }

    @Override
    public Types getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.type.getName();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean equals(Type<?> toType) {
        return this.type == toType.getType();
    }

    protected ValueConversionException valueConversionException(Object value, Type<?> valueType, Exception cause) {
        return new ValueConversionException(value, valueType, this, cause);
    }

    protected TypeConversionException typeConversionException(Type<?> typeFrom, Type<?> typeTo) {
        return new TypeConversionException(typeFrom, typeTo);
    }

    @Override
    public T sum(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        throw this.operationNotSupportedException("sum");
    }

    @Override
    public T minus(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        throw this.operationNotSupportedException("minus");
    }

    @Override
    public T mul(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        throw this.operationNotSupportedException("multiplication");
    }

    @Override
    public T divide(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        throw this.operationNotSupportedException("divide");
    }

    @Override
    public T degree(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        throw this.operationNotSupportedException("degree");
    }

    @Override
    public T negative(Object value, Type<?> type) throws ValueConversionException {
        throw this.operationNotSupportedException("negative");
    }

    @Override
    public void validateSum(Type<?> type) throws TypeConversionException {
        throw this.operationNotSupportedForTypesException("sum");
    }

    @Override
    public void validateMinus(Type<?> type) throws TypeConversionException {
        throw this.operationNotSupportedForTypesException("minus");
    }

    @Override
    public void validateMul(Type<?> type) throws TypeConversionException {
        throw this.operationNotSupportedForTypesException("mul");
    }

    @Override
    public void validateDivide(Type<?> type) throws TypeConversionException {
        throw this.operationNotSupportedForTypesException("divide");
    }

    @Override
    public void validateDegree(Type<?> type) throws TypeConversionException {
        throw this.operationNotSupportedForTypesException("degree");
    }

    @Override
    public void validateNegative() throws TypeConversionException {
        throw this.operationNotSupportedForTypesException("negative");
    }

    @Override
    public boolean equals(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return this.convertValue(value1, type1).equals(this.convertValue(value2, type2));
    }

    @Override
    public void validateEquals(Type<?> type) throws TypeConversionException {
        this.canConvert(type);
    }

    @Override
    public boolean lessthan(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        throw this.operationNotSupportedException("lessthan");
    }

    @Override
    public boolean greaterthan(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        throw this.operationNotSupportedException("greaterthan");
    }

    @Override
    public boolean lessthanOrEquals(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        throw this.operationNotSupportedException("lessthanOrEquals");
    }

    @Override
    public boolean greaterthanOrEquals(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        throw this.operationNotSupportedException("greaterthanOrEquals");
    }

    @Override
    public void validateLessthan(Type<?> type) throws TypeConversionException {
        throw this.operationNotSupportedForTypesException("lessthan");
    }

    @Override
    public void validateGreaterthan(Type<?> type) throws TypeConversionException {
        throw this.operationNotSupportedForTypesException("greaterthan");
    }

    @Override
    public void validateLessthanOrEquals(Type<?> type) throws TypeConversionException {
        throw this.operationNotSupportedForTypesException("lessthanOrEquals");
    }

    @Override
    public void validateGreaterthanOrEquals(Type<?> type) throws TypeConversionException {
        throw this.operationNotSupportedForTypesException("greaterthanOrEquals");
    }

    @Override
    public void validateIterate(Type<?> type) throws TriggerFunctionException {
        throw new TriggerFunctionException("Failed to iterate variable of type '" + type.getName() + "'.");
    }

    private ValueConversionException operationNotSupportedException(String operation) {
        return new ValueConversionException("Operation '" + operation + "' not available for type '" + this.getName() + "'.");
    }

    private TypeConversionException operationNotSupportedForTypesException(String operation) {
        return new TypeConversionException("Operation '" + operation + "' not available for type '" + this.getName() + "'.");
    }

    @Override
    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return this.onEscapeValue(value);
    }

    @Override
    public String toString(Object value) {
        if (value == null) {
            return "null";
        }
        return this.onToString(value);
    }

    protected abstract String onEscapeValue(Object var1);

    protected String onToString(Object value) {
        return value.toString();
    }

    @Override
    public String getDefaultInitializer(String defaultValue) {
        return null;
    }

    @Override
    public String getDefaultObjectInitializer(String defaultValue) {
        return this.getDefaultInitializer(defaultValue);
    }

    @Override
    public String getConstructorInitializer(String name, String defaultValue) {
        return null;
    }
}

