/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.types;

import com.streamscape.sef.evtrigger.function.types.AbstractType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;

public abstract class AbstractNumberType<T extends Number>
extends AbstractType<T> {
    AbstractNumberType(Types type) {
        super(type);
    }

    @Override
    public void canConvert(Type<?> typeFrom) throws TypeConversionException {
        if (typeFrom.getType() == this.getType()) {
            return;
        }
        switch (typeFrom.getType()) {
            case INT: 
            case SHORT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BIGDECIMAL: 
            case BIGINT: 
            case BYTE: 
            case NULLTYPE: 
            case OBJECT: {
                return;
            }
        }
        throw this.typeConversionException(typeFrom, this);
    }

    @Override
    public T sum(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        return this.onSum((Number)this.convertValue(value1, type1), (Number)this.convertValue(value2, type2));
    }

    @Override
    public T minus(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        return this.onMinus((Number)this.convertValue(value1, type1), (Number)this.convertValue(value2, type2));
    }

    @Override
    public T mul(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        return this.onMul((Number)this.convertValue(value1, type1), (Number)this.convertValue(value2, type2));
    }

    @Override
    public T divide(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        Number numberValue2 = (Number)this.convertValue(value2, type2);
        if (numberValue2.doubleValue() == 0.0) {
            throw new ValueConversionException("Divide on 0 is not allowed.");
        }
        return this.onDivide((Number)this.convertValue(value1, type1), numberValue2);
    }

    @Override
    public T degree(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        return this.onDegree((Number)this.convertValue(value1, type2), (Number)this.convertValue(value2, type2));
    }

    @Override
    public T negative(Object value, Type<?> type) throws ValueConversionException {
        return this.onNegative((Number)this.convertValue(value, type));
    }

    protected abstract T onSum(Number var1, Number var2) throws ValueConversionException;

    protected abstract T onMinus(Number var1, Number var2) throws ValueConversionException;

    protected abstract T onMul(Number var1, Number var2) throws ValueConversionException;

    protected abstract T onDivide(Number var1, Number var2) throws ValueConversionException;

    protected abstract T onDegree(Number var1, Number var2) throws ValueConversionException;

    protected abstract T onNegative(Number var1) throws ValueConversionException;

    @Override
    public void validateSum(Type<?> type) throws TypeConversionException {
        this.canConvert(type);
    }

    @Override
    public void validateMinus(Type<?> type) throws TypeConversionException {
        this.canConvert(type);
    }

    @Override
    public void validateMul(Type<?> type) throws TypeConversionException {
        this.canConvert(type);
    }

    @Override
    public void validateDivide(Type<?> type) throws TypeConversionException {
        this.canConvert(type);
    }

    @Override
    public void validateDegree(Type<?> type) throws TypeConversionException {
        this.canConvert(type);
    }

    @Override
    public void validateNegative() throws TypeConversionException {
    }

    @Override
    public boolean equals(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        Number number1 = (Number)this.convertValue(value1, type1);
        Number number2 = TypeFactory.DOUBLE.convertValue(value2, type2);
        return number1.doubleValue() == number2.doubleValue();
    }

    @Override
    public boolean lessthan(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        if (value1 == null || value2 == null) {
            throw new ValueConversionException("Null values not allowed in '<' condition.");
        }
        Number number1 = (Number)this.convertValue(value1, type1);
        Number number2 = TypeFactory.DOUBLE.convertValue(value2, type2);
        return number1.doubleValue() < number2.doubleValue();
    }

    @Override
    public boolean greaterthan(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        if (value1 == null || value2 == null) {
            throw new ValueConversionException("Null values not allowed in '>' condition.");
        }
        Number number1 = (Number)this.convertValue(value1, type1);
        Number number2 = TypeFactory.DOUBLE.convertValue(value2, type2);
        return number1.doubleValue() > number2.doubleValue();
    }

    @Override
    public boolean lessthanOrEquals(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        if (value1 == null || value2 == null) {
            throw new ValueConversionException("Null values not allowed in '<=' condition.");
        }
        Number number1 = (Number)this.convertValue(value1, type1);
        Number number2 = TypeFactory.DOUBLE.convertValue(value2, type2);
        return number1.doubleValue() <= number2.doubleValue();
    }

    @Override
    public boolean greaterthanOrEquals(Object value1, Type<?> type1, Object value2, Type<?> type2) throws ValueConversionException {
        if (value1 == null || value2 == null) {
            throw new ValueConversionException("Null values not allowed in '>=' condition.");
        }
        Number number1 = (Number)this.convertValue(value1, type1);
        Number number2 = TypeFactory.DOUBLE.convertValue(value2, type2);
        return number1.doubleValue() >= number2.doubleValue();
    }

    @Override
    public void validateEquals(Type<?> type) throws TypeConversionException {
        TypeFactory.DOUBLE.canConvert(type);
    }

    @Override
    public void validateLessthan(Type<?> type) throws TypeConversionException {
        TypeFactory.DOUBLE.canConvert(type);
    }

    @Override
    public void validateGreaterthan(Type<?> type) throws TypeConversionException {
        TypeFactory.DOUBLE.canConvert(type);
    }

    @Override
    public void validateLessthanOrEquals(Type<?> type) throws TypeConversionException {
        TypeFactory.DOUBLE.canConvert(type);
    }

    @Override
    public void validateGreaterthanOrEquals(Type<?> type) throws TypeConversionException {
        TypeFactory.DOUBLE.canConvert(type);
    }

    @Override
    protected String onEscapeValue(Object value) {
        return value.toString();
    }

    protected String removeNumberSuffix(String value) {
        if (value != null && value.length() >= 2 && value.endsWith("l") || value.endsWith("L") || value.endsWith("f") || value.endsWith("F") || value.endsWith("d") || value.endsWith("D")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }
}

