/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.statement;

import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionException;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.statement.AbstractRepeatableStatement;
import com.streamscape.sef.evtrigger.function.statement.AbstractStatement;
import com.streamscape.sef.evtrigger.function.statement.Statement;
import com.streamscape.sef.evtrigger.function.statement.TriggerFunctionBreakException;
import com.streamscape.sef.evtrigger.function.statement.TriggerFunctionContinueException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;

public class WhileStatement
extends AbstractRepeatableStatement {
    private AbstractExpression condition;

    public WhileStatement(AbstractStatement parent) {
        super(Statement.StatementType.WHILE, parent);
    }

    public void setCondition(AbstractExpression condition) {
        this.condition = condition;
    }

    @Override
    protected void onExecute(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        Object value;
        while (!((value = this.condition.evaluateValueType((TriggerFunctionContext)context).value) instanceof Boolean) || ((Boolean)value).booleanValue()) {
            try {
                if (this.repeatableBlock == null) continue;
                this.repeatableBlock.execute(context);
            }
            catch (TriggerFunctionBreakException exception) {
                break;
            }
            catch (TriggerFunctionContinueException exception) {
            }
        }
    }

    @Override
    protected void onValidate(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        this.condition.validate(context);
        if (this.repeatableBlock != null) {
            this.repeatableBlock.validate(context);
        }
        if (this.condition.getResultType() != TypeFactory.BOOLEAN) {
            throw this.initException(new TriggerFunctionException("WHILE condition should return type BOOLEAN, but returns " + this.condition.getResultType().getName()), this.condition.getBeginPosition());
        }
    }

    @Override
    protected void onCompile(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        this.condition = this.condition.compile(context);
        if (this.repeatableBlock != null) {
            this.repeatableBlock.compile(context);
        }
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append("WHILE (");
        this.condition.toString(builder);
        builder.append(")");
        if (this.repeatableBlock != null) {
            this.repeatableBlock.toString(builder);
        } else {
            builder.append(";\n");
        }
    }
}

