/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.statement;

import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContext;
import com.streamscape.sef.evtrigger.function.statement.Variable;
import com.streamscape.sef.evtrigger.function.types.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VariablePool {
    private VariablePool parentVariablePool;
    private List<Variable> variables = new ArrayList<Variable>();
    private List<Variable> systemVariables = new ArrayList<Variable>();

    VariablePool() {
        this(null);
    }

    VariablePool(VariablePool parent) {
        this.parentVariablePool = parent;
    }

    public boolean existsVariable(TriggerFunctionParserContext context, String name) {
        return VariablePool.existsVariable(this.variables, name) || this.parentVariablePool != null && this.parentVariablePool.existsVariable(context, name) || this.parentVariablePool == null && context != null && context.existsSystemVariableType(name);
    }

    public void addVariable(TriggerFunctionParserContext context, Variable variable) throws Exception {
        if (this.existsVariable(context, variable.getName())) {
            throw new Exception("Variable '" + variable.getName() + "' already exists.");
        }
        this.variables.add(variable);
    }

    public Variable getVariable(TriggerFunctionParserContext context, String name) {
        Variable variable = VariablePool.getVariable(this.variables, name);
        if (variable == null) {
            if (this.parentVariablePool == null) {
                Type<?> systemVariableType;
                variable = VariablePool.getVariable(this.systemVariables, name);
                if (variable == null && context != null && (systemVariableType = context.getSystemVariableType(name)) != null) {
                    variable = new Variable(systemVariableType, name);
                    this.systemVariables.add(variable);
                }
            } else {
                variable = this.parentVariablePool.getVariable(context, name);
            }
        }
        return variable;
    }

    public Variable getVariable(String name) {
        return this.getVariable(null, name);
    }

    public Collection<Variable> listVariables() {
        return this.variables;
    }

    public Collection<Variable> listSystemVariables() {
        return this.systemVariables;
    }

    public Collection<Variable> getAllHierarchyVariables() {
        ArrayList<Variable> result = new ArrayList<Variable>();
        if (this.variables != null) {
            result.addAll(this.variables);
        }
        if (this.systemVariables != null) {
            result.addAll(this.systemVariables);
        }
        if (this.parentVariablePool != null) {
            result.addAll(this.parentVariablePool.getAllHierarchyVariables());
        }
        return result;
    }

    public void resetVariales(boolean withTransient) {
        for (Variable variable : this.variables) {
            variable.reset(withTransient);
        }
        for (Variable variable : this.systemVariables) {
            variable.reset();
        }
    }

    private static boolean existsVariable(List<Variable> variablesList, String name) {
        for (Variable variable : variablesList) {
            if (!variable.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private static Variable getVariable(List<Variable> variablesList, String name) {
        for (Variable variable : variablesList) {
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }
}

