/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.statement;

import com.streamscape.Trace;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import java.io.Closeable;
import java.io.IOException;

public class Variable
implements ValueAccessor {
    private Type<?> type;
    private String name;
    private Object value;
    private Scope scope = Scope.NONE;
    private boolean isInitialized;

    public Variable(Type<?> type, String name) {
        this(type, name, Scope.NONE);
    }

    public Variable(Type<?> type, String name, Scope scope) {
        this.type = type;
        this.name = name;
        this.value = null;
        this.isInitialized = false;
        this.scope = scope;
    }

    @Override
    public Type<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Scope getScope() {
        return this.scope;
    }

    @Override
    public void assignValue(Object value, Type<?> valueType, TriggerFunctionContext context) throws ValueConversionException, ExpressionExecutionException {
        this.assignValue(value, valueType, context, false);
    }

    public void assignValue(Object value, Type<?> valueType, TriggerFunctionContext context, boolean init) throws ValueConversionException, ExpressionExecutionException {
        if (this.isFinal() && this.isInitialized()) {
            throw new ValueConversionException("Final variable can be initialized only once.");
        }
        if (this.isTransient() && this.isInitialized() && init) {
            return;
        }
        this.reset();
        this.value = this.type.convertValue(value, valueType);
        this.isInitialized = true;
    }

    public void narrowResultType(Type<?> type) {
        this.type = type;
    }

    @Override
    public Object getValue(TriggerFunctionContext context) throws ValueConversionException, ExpressionExecutionException {
        return this.value;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public boolean isFinal() {
        return this.scope == Scope.FINAL;
    }

    public boolean isTransient() {
        return this.scope == Scope.TRANSIENT;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return (this.isFinal() ? "final " : (this.isTransient() ? "transient" : "")) + this.type.getName() + " " + this.name + ";";
    }

    public void reset() {
        this.reset(false);
    }

    public void reset(boolean withTransient) {
        if (!this.isTransient() || withTransient) {
            this.isInitialized = false;
            if (this.value != null && this.value instanceof Closeable) {
                try {
                    ((Closeable)this.value).close();
                }
                catch (IOException exception) {
                    Trace.logError(this, "Failed to close variable '" + String.valueOf(this) + "'. Cause: " + exception.getMessage());
                }
            }
            this.value = null;
        }
    }

    public static enum Scope {
        NONE,
        FINAL,
        TRANSIENT;

    }
}

