/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.statement;

import com.streamscape.sdo.excp.LanguageException;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionDisableException;
import com.streamscape.sef.evtrigger.function.TriggerFunctionException;
import com.streamscape.sef.evtrigger.function.TriggerFunctionInvalidateException;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.statement.AbstractStatement;
import com.streamscape.sef.evtrigger.function.statement.AbstractStatementWithErrorHandling;
import com.streamscape.sef.evtrigger.function.statement.Statement;
import com.streamscape.sef.evtrigger.function.statement.StatementBlock;
import com.streamscape.sef.evtrigger.function.types.EventType;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;

public class TryCatchStatement
extends AbstractStatementWithErrorHandling {
    StatementBlock tryBlock;
    StatementBlock catchBlock;
    StatementBlock finallyBlock;
    String exceptionName;

    public TryCatchStatement(AbstractStatement parent) {
        super(Statement.StatementType.TRY_CATCH, parent);
    }

    public void setTryBlock(StatementBlock tryBlock) {
        this.tryBlock = tryBlock;
    }

    public void setCatchBlock(StatementBlock catchBlock, String exceptionName) {
        this.catchBlock = catchBlock;
        this.exceptionName = exceptionName;
    }

    public void setFinallyBlock(StatementBlock finallyBlock) {
        this.finallyBlock = finallyBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onExecute(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        block11: {
            try {
                this.tryBlock.execute(context);
            }
            catch (TriggerFunctionDisableException | TriggerFunctionInvalidateException exception) {
                throw exception;
            }
            catch (TriggerFunctionException exception) {
                if (this.catchBlock == null) break block11;
                try {
                    EventType languageExceptionType;
                    LanguageException languageException = LanguageException.create(exception);
                    try {
                        languageExceptionType = TypeFactory.createEventType(context, "exception.Language");
                    }
                    catch (Exception e) {
                        throw this.initException(new TriggerFunctionException("Failed to create Event type for eventId [exception.Language]. Cause: " + e.getMessage(), e));
                    }
                    this.catchBlock.getStatementContext().getVariablePool().getVariable(this.exceptionName).assignValue(languageException, languageExceptionType, context);
                    this.catchBlock.execute(context);
                }
                catch (ValueConversionException exception1) {
                    throw this.initException(new TriggerFunctionException(exception1.getMessage(), exception1));
                }
            }
            finally {
                if (this.finallyBlock != null) {
                    this.finallyBlock.execute(context);
                }
            }
        }
    }

    @Override
    protected void onValidate(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        this.tryBlock.validate(context);
        if (this.catchBlock != null) {
            this.catchBlock.validate(context);
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.validate(context);
        }
    }

    @Override
    protected void onCompile(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        this.tryBlock.compile(context);
        if (this.catchBlock != null) {
            this.catchBlock.compile(context);
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.compile(context);
        }
        if (this.finallyBlock == null && this.catchBlock == null && !context.isCompleteMode()) {
            throw this.initException(new TriggerFunctionException("At less catch or finally block should be specified after try block."));
        }
    }

    @Override
    public void reset(boolean withTransient) {
        super.reset(withTransient);
        this.tryBlock.reset(withTransient);
        if (this.catchBlock != null) {
            this.catchBlock.reset(withTransient);
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.reset(withTransient);
        }
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append("try\n");
        this.tryBlock.toString(builder);
        if (this.catchBlock != null) {
            builder.append("catch\n");
            this.catchBlock.toString(builder);
        }
        if (this.finallyBlock != null) {
            builder.append("finally\n");
            this.finallyBlock.toString(builder);
        }
    }
}

