/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.statement;

import com.streamscape.sdo.excp.LanguageException;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionException;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.statement.AbstractStatement;
import com.streamscape.sef.evtrigger.function.statement.AbstractStatementWithErrorHandling;
import com.streamscape.sef.evtrigger.function.statement.Statement;

public class ThrowStatement
extends AbstractStatementWithErrorHandling {
    private AbstractExpression expression;

    public ThrowStatement(AbstractStatement parent, AbstractExpression expression) {
        super(Statement.StatementType.THROW, parent);
        this.expression = expression;
    }

    @Override
    protected void onExecute(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        Object exception = this.expression.evaluateValueType((TriggerFunctionContext)context).value;
        if (exception == null) {
            throw this.initException(new TriggerFunctionException("Failed to throw null object."));
        }
        if (exception instanceof ExpressionExecutionException) {
            throw (ExpressionExecutionException)exception;
        }
        if (exception instanceof TriggerFunctionException) {
            throw (TriggerFunctionException)exception;
        }
        if (exception instanceof LanguageException) {
            throw (TriggerFunctionException)((LanguageException)exception).getOriginalException();
        }
        if (exception instanceof Exception) {
            throw new TriggerFunctionException(((Exception)exception).getMessage(), (Exception)exception);
        }
        throw this.initException(new TriggerFunctionException("Failed to throw object of class " + String.valueOf(exception.getClass()) + "."));
    }

    @Override
    protected void onValidate(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        this.expression.validate(context);
    }

    @Override
    protected void onCompile(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        this.expression = this.expression.compile(context);
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append("throw ");
        this.expression.toString(builder);
        builder.append(";");
    }
}

