/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.statement;

import com.streamscape.sef.evtrigger.function.expression.function.DataspaceFunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitsManager;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnitsManagerFactory;
import com.streamscape.sef.evtrigger.function.statement.VariablePool;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class StatementContext {
    private String script;
    private StatementContext parentContext;
    private VariablePool variablePool;
    private FunctionsUnitsManager functionsUnitsManager;
    private DataspaceFunctionsUnit defaultDataspaceFunctionsUnit;
    private Set<String> raisedEventIds;
    private Set<String> raisedEventIdsForReply;
    private Set<String> usedEventIds;
    private boolean isRaiseAdvisory = false;

    StatementContext(String script) {
        this.script = script;
        this.parentContext = null;
        this.variablePool = new VariablePool();
        this.functionsUnitsManager = new FunctionsUnitsManagerFactory().getBaseFunctionsUnitsManager();
        this.defaultDataspaceFunctionsUnit = new DataspaceFunctionsUnit();
        this.defaultDataspaceFunctionsUnit.setDefault(true);
        this.defaultDataspaceFunctionsUnit.setDataspaceName("SYS");
    }

    StatementContext(StatementContext parent) {
        this.script = parent.script;
        this.parentContext = parent;
        this.variablePool = new VariablePool(parent.variablePool);
        this.functionsUnitsManager = new FunctionsUnitsManagerFactory().createHierarchicalFunctionsUnitsManager(parent.functionsUnitsManager);
        this.defaultDataspaceFunctionsUnit = parent.defaultDataspaceFunctionsUnit;
    }

    public VariablePool getVariablePool() {
        return this.variablePool;
    }

    public FunctionsUnitsManager getFunctionsUnitsManager() {
        return this.functionsUnitsManager;
    }

    public DataspaceFunctionsUnit getDefaultDataspaceFunctionsUnit() {
        if (this.parentContext != null) {
            return this.parentContext.defaultDataspaceFunctionsUnit;
        }
        return this.defaultDataspaceFunctionsUnit;
    }

    public String getScript() {
        return this.script;
    }

    public void addRaisedEventId(String eventId) {
        if (this.raisedEventIds == null) {
            this.raisedEventIds = new HashSet<String>();
        }
        this.raisedEventIds.add(eventId);
        if (this.parentContext != null) {
            this.parentContext.addRaisedEventId(eventId);
        }
        this.addUsedEventId(eventId);
    }

    public void addRaisedEventIdForReply(String eventId) {
        if (this.raisedEventIdsForReply == null) {
            this.raisedEventIdsForReply = new HashSet<String>();
        }
        this.raisedEventIdsForReply.add(eventId);
        if (this.parentContext != null) {
            this.parentContext.addRaisedEventIdForReply(eventId);
        }
    }

    public boolean isEventIdForReply(String eventId) {
        return this.raisedEventIdsForReply != null && this.raisedEventIdsForReply.contains(eventId);
    }

    public List<String> listRaisedEventIds() {
        if (this.raisedEventIds == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(this.raisedEventIds);
    }

    public boolean isRaiseAdvisory() {
        return this.isRaiseAdvisory;
    }

    public void setRaiseAdvisory(boolean isRaiseAdvisory) {
        this.isRaiseAdvisory = isRaiseAdvisory;
        if (this.parentContext != null) {
            this.parentContext.setRaiseAdvisory(isRaiseAdvisory);
        }
    }

    public void addUsedEventId(String eventId) {
        if (this.usedEventIds == null) {
            this.usedEventIds = new HashSet<String>();
        }
        this.usedEventIds.add(eventId);
        if (this.parentContext != null) {
            this.parentContext.addUsedEventId(eventId);
        }
    }

    public List<String> listUsedEventIds() {
        if (this.usedEventIds == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(this.usedEventIds);
    }

    protected void resetBeforeCompile() {
        this.raisedEventIds = null;
        this.raisedEventIdsForReply = null;
        this.usedEventIds = null;
        this.isRaiseAdvisory = false;
        if (this.parentContext != null) {
            this.parentContext.resetBeforeCompile();
        }
    }
}

