/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.statement;

import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionException;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContextImpl;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.statement.AbstractStatement;
import com.streamscape.sef.evtrigger.function.statement.Statement;
import com.streamscape.sef.evtrigger.function.statement.StatementContext;
import com.streamscape.sef.evtrigger.function.statement.StatementResult;
import com.streamscape.sef.evtrigger.function.statement.TriggerFunctionReturnException;
import com.streamscape.sef.evtrigger.function.statement.Variable;
import com.streamscape.sef.evtrigger.function.statement.VariablePool;
import com.streamscape.sef.evtrigger.function.types.EventType;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import java.util.ArrayList;
import java.util.List;

public class StatementBlock
extends AbstractStatement {
    private List<Statement> statements = new ArrayList<Statement>();
    private StatementContext statementContext;

    public StatementBlock(String buffer) {
        super(Statement.StatementType.STATEMENT_BLOCK, null);
        this.statementContext = new StatementContext(buffer);
    }

    public StatementBlock(AbstractStatement parent) {
        super(Statement.StatementType.STATEMENT_BLOCK, parent);
        this.statementContext = new StatementContext(parent.getStatementContext());
    }

    @Override
    public StatementContext getStatementContext() {
        return this.statementContext;
    }

    public void initializeVariables(TriggerFunctionContext context) throws TriggerFunctionException {
        if (this.isRootBlock()) {
            this.reset(false);
            for (Variable variable : this.getVariablePool().listSystemVariables()) {
                if (variable.isInitialized()) continue;
                if (!context.existsSystemVariableValue(variable.getName())) {
                    throw new TriggerFunctionException("System variable '" + variable.getName() + "' is not initialized.");
                }
                Object value = context.getSystemVariableValue(variable.getName());
                try {
                    variable.assignValue(value, TypeFactory.resolveObjectType(value, context), context);
                }
                catch (ValueConversionException exception) {
                    throw new TriggerFunctionException("Failed to assign value to system variable '" + variable.getName() + "'. Cause: " + exception.getMessage(), exception);
                }
                catch (ExpressionExecutionException exception) {
                    throw new TriggerFunctionException("Failed to assign value to system variable '" + variable.getName() + "'. Cause: " + exception.getMessage(), exception);
                }
            }
        }
    }

    @Override
    public StatementResult execute(TriggerFunctionContext context) throws TriggerFunctionException {
        block3: {
            this.initializeVariables(context);
            try {
                for (Statement statement : this.statements) {
                    statement.execute(context);
                }
            }
            catch (TriggerFunctionReturnException exception) {
                if (this.isRootBlock()) break block3;
                throw exception;
            }
        }
        return StatementResult.OK;
    }

    @Override
    public void validate(TriggerFunctionContext context) throws TriggerFunctionException {
        ((TriggerFunctionParserContextImpl)((Object)context)).validateSystemVariableTypes();
        for (Statement statement : this.statements) {
            statement.validate(context);
        }
    }

    @Override
    public void compile(TriggerFunctionContext context) throws TriggerFunctionException {
        EventType e;
        if (this.isRootBlock() && this.statementContext != null) {
            this.statementContext.resetBeforeCompile();
        }
        if (context.getActionableEventType() != null && (e = (EventType)context.getActionableEventType()).getEventId() != null) {
            this.statementContext.addUsedEventId(e.getEventId());
        }
        for (Statement statement : this.statements) {
            statement.compile(context);
        }
    }

    public void addStatement(Statement statement) {
        this.statements.add(statement);
    }

    public VariablePool getVariablePool() {
        return this.getStatementContext().getVariablePool();
    }

    public int getStatementsCount() {
        return this.statements.size();
    }

    @Override
    public void reset(boolean withTransient) {
        for (Statement statement : this.statements) {
            statement.reset(withTransient);
        }
        this.getVariablePool().resetVariales(withTransient);
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append("{\n");
        for (Variable variable : this.getStatementContext().getVariablePool().listVariables()) {
            builder.append(variable.toString()).append("\n");
        }
        for (Statement statement : this.statements) {
            statement.toString(builder);
            builder.append("\n");
        }
        builder.append("}\n");
    }
}

