/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.statement;

import com.streamscape.Trace;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sef.dispatcher.AbstractActionStatement;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionException;
import com.streamscape.sef.evtrigger.function.TriggerFunctionRaiseEventFailedException;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.statement.AbstractStatement;
import com.streamscape.sef.evtrigger.function.statement.Statement;
import com.streamscape.sef.evtrigger.function.types.EventType;
import com.streamscape.sef.evtrigger.function.types.ObjectType;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.Types;

public class RaiseEventStatement
extends AbstractActionStatement {
    private AbstractExpression expression;
    private EventModel eventModel = EventModel.NONE;
    private String raiseOnEventId = null;

    public RaiseEventStatement(AbstractStatement parent, AbstractExpression expression, EventModel eventModel) {
        super(Statement.StatementType.RAISE_EVENT, parent);
        this.expression = expression;
        this.eventModel = eventModel;
    }

    @Override
    protected void onExecute(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        try {
            Expression.ValueTypeResult result = this.expression.evaluateValueType(context);
            if (result.type == null || result.type.getType() != Types.EVENT && result.type.getType() != Types.OBJECT && !(((ObjectType)result.type).getRealType() instanceof EventType)) {
                throw new Exception("Cannot raise object of type '" + (result != null ? result.type.getName() : "null") + "'.");
            }
            if (result.value == null) {
                throw new Exception("Cannot raise null object.");
            }
            if (!(result.value instanceof ImmutableEventDatagram)) {
                throw new Exception("Cannot raise object of type '" + result.value.getClass().getName() + "'.");
            }
            try {
                ImmutableEventDatagram event = (ImmutableEventDatagram)result.value;
                if (result.value == context.getActionableEvent() && context.getActionableEvent().getEventId().startsWith("e.action.")) {
                    super.resetEvent(event);
                    if (this.raiseOnEventId == null) {
                        this.setEventId(event, ((EventType)result.type).getEventId());
                    }
                }
                if (this.raiseOnEventId != null) {
                    this.setEventId(event, this.raiseOnEventId);
                }
                if (context.getEventTriggerDefinition() != null && context.getEventTriggerDefinition().getEventScope() == EventScope.LOCAL) {
                    try {
                        this.setEventId(event, "e.action." + event.getEventId());
                    }
                    catch (SDOFormatException error) {
                        Trace.logException(this, error, true);
                    }
                }
                context.raiseEvent(event, context.getEventTriggerDefinition() != null ? context.getEventTriggerDefinition().getEventScope() : EventScope.INHERITED);
            }
            catch (Exception exception) {
                Trace.logException(this, exception, false);
                throw new Exception("Event raising error: " + exception.getMessage());
            }
        }
        catch (Exception exception) {
            throw this.initException(new TriggerFunctionRaiseEventFailedException(exception.getMessage()));
        }
    }

    @Override
    protected void onValidate(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        this.expression.validate(context);
        if (this.expression.getResultType().getType() != Types.EVENT) {
            throw this.initException(new TriggerFunctionException("Cannot raise object of type '" + this.expression.getResultType().getName() + "'. Only events can be raised."));
        }
        switch (this.eventModel.ordinal()) {
            case 1: {
                String className = ((EventType)this.expression.getResultType()).getSemanticTypeClassName();
                try {
                    Class<?> exceptionClass = context.loadClass(className);
                    if (!AdvisoryEventDatagram.class.isAssignableFrom(exceptionClass)) {
                        throw this.initException(new TriggerFunctionException("Raise advisory statement accepts only advisory event datagrams, but passed '" + exceptionClass.getSimpleName() + "'."));
                    }
                    break;
                }
                catch (ClassNotFoundException exception) {
                    throw this.initException(new TriggerFunctionException("Failed to load raised advisory class '" + className + "'.", exception));
                }
            }
            case 2: {
                String className = ((EventType)this.expression.getResultType()).getSemanticTypeClassName();
                try {
                    Class<?> exceptionClass = context.loadClass(className);
                    if (!ExceptionEventDatagram.class.isAssignableFrom(exceptionClass)) {
                        throw this.initException(new TriggerFunctionException("Raise exception statement accepts only exception event datagrams, but passed '" + exceptionClass.getSimpleName() + "'."));
                    }
                    break;
                }
                catch (ClassNotFoundException exception) {
                    throw this.initException(new TriggerFunctionException("Failed to load raised exception class '" + className + "'.", exception));
                }
            }
            case 0: {
                break;
            }
            case 3: {
                break;
            }
        }
        if (this.raiseOnEventId == null) {
            EventType eventType = (EventType)this.expression.getResultType();
            if (eventType.getEventId() == null) {
                throw this.initException(new TriggerFunctionException("Cannot raise event without initialized eventId."));
            }
        } else {
            try {
                TypeFactory.createEventType(context, this.raiseOnEventId);
            }
            catch (Exception exception) {
                throw this.initException(new TriggerFunctionException("Failed to create event type for event [" + this.raiseOnEventId + "]. Cause: " + exception.getMessage()), this.expression.getEndPosition() + 1);
            }
        }
    }

    @Override
    protected void onCompile(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        this.expression = this.expression.compile(context);
        if (this.expression.getResultType().getType() != Types.EVENT) {
            throw this.initException(new TriggerFunctionException("Cannot raise object of type '" + this.expression.getResultType().getName() + "'. Only events can be raised."));
        }
        if (this.raiseOnEventId == null) {
            EventType eventType = (EventType)this.expression.getResultType();
            if (eventType.getEventId() == null) {
                throw this.initException(new TriggerFunctionException("Cannot raise event without initialized eventId."));
            }
            String eventId = eventType.getEventId();
            boolean eventIdFoReply = false;
            if (eventId.startsWith("e.reply.")) {
                eventId = eventId.substring("e.reply.".length());
                eventIdFoReply = true;
            } else if (eventId.startsWith("e.sys.reply.")) {
                eventId = eventId.substring("e.sys.reply.".length());
                eventIdFoReply = true;
            }
            this.getStatementContext().addRaisedEventId(eventId);
            if (eventIdFoReply) {
                this.getStatementContext().addRaisedEventIdForReply(eventId);
            }
        } else {
            if (!StringUtils.validateEventId(this.raiseOnEventId)) {
                throw new TriggerFunctionException("Invalid event id [" + this.raiseOnEventId + "].");
            }
            this.getStatementContext().addRaisedEventId(this.raiseOnEventId);
        }
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append("raise ").append(this.expression.toString());
        if (this.raiseOnEventId != null) {
            builder.append(" on ").append(this.raiseOnEventId);
        }
        builder.append(";");
    }

    public void setRaiseOnEventId(String raiseOnEventId) {
        this.raiseOnEventId = raiseOnEventId;
    }

    public static enum EventModel {
        EVENT,
        ADVISORY,
        EXCEPTION,
        NONE;

    }
}

