/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.statement;

import com.streamscape.Trace;
import com.streamscape.sdo.advisory.EventTriggerAdvisory;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionException;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.statement.AbstractStatement;
import com.streamscape.sef.evtrigger.function.statement.AbstractStatementWithErrorHandling;
import com.streamscape.sef.evtrigger.function.statement.Statement;
import com.streamscape.sef.evtrigger.function.types.EventType;

public class RaiseAdvisoryStatement
extends AbstractStatementWithErrorHandling {
    public RaiseAdvisoryStatement(AbstractStatement parent) {
        super(Statement.StatementType.RAISE_ADVISORY, parent);
    }

    @Override
    protected void onExecute(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        try {
            Trace.logDebug(this, "Raising advisory...");
            EventTriggerAdvisory advisory = new EventTriggerAdvisory();
            advisory.setActionableEventId(((EventType)context.getActionableEventType()).getEventId());
            advisory.setComponentModel(context.getComponent().getComponentModel());
            advisory.setComponentName(context.getComponent().getName());
            advisory.setComponentType(context.getComponent().getType());
            advisory.setTriggerName(context.getEventTriggerDefinition().getName());
            context.raiseEvent(advisory, EventScope.INHERITED);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Raising of advisory failed.");
        }
    }

    @Override
    protected void onValidate(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        if (context.getActionableEventType() == null || ((EventType)context.getActionableEventType()).getEventId() == null || ((EventType)context.getActionableEventType()).getEventId().length() == 0) {
            throw this.initException(new TriggerFunctionException("Raise advisory statement is not allowed when incoming eventId not set."));
        }
        if (context.getEventTriggerDefinition() == null) {
            throw this.initException(new TriggerFunctionException("Raise advisory statement is not allowed when TriggerDefinition not set."));
        }
    }

    @Override
    protected void onCompile(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        this.getStatementContext().setRaiseAdvisory(true);
        this.getStatementContext().addRaisedEventId("advisory.exec.EventTrigger");
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append("raise advisory;");
    }
}

