/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.statement;

import com.streamscape.lib.utils.Pair;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionException;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.statement.AbstractStatement;
import com.streamscape.sef.evtrigger.function.statement.AbstractStatementWithErrorHandling;
import com.streamscape.sef.evtrigger.function.statement.Statement;
import com.streamscape.sef.evtrigger.function.statement.StatementBlock;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import java.util.ArrayList;
import java.util.List;

public class IfStatement
extends AbstractStatementWithErrorHandling {
    private List<Pair<AbstractExpression, StatementBlock>> conditionsBlocks = new ArrayList<Pair<AbstractExpression, StatementBlock>>();
    private StatementBlock elseBlock = null;

    public IfStatement(AbstractStatement parent) {
        super(Statement.StatementType.IF, parent);
    }

    public void addConditionBlock(AbstractExpression condition, StatementBlock block) {
        this.conditionsBlocks.add(new Pair<AbstractExpression, StatementBlock>(condition, block));
    }

    public void setElseBlock(StatementBlock elseBlock) {
        this.elseBlock = elseBlock;
    }

    @Override
    protected void onExecute(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        for (Pair<AbstractExpression, StatementBlock> pair : this.conditionsBlocks) {
            Object value = ((AbstractExpression)pair.first).evaluateValueType((TriggerFunctionContext)context).value;
            if (!(value instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            ((StatementBlock)pair.second).execute(context);
            return;
        }
        if (this.elseBlock != null) {
            this.elseBlock.execute(context);
        }
    }

    @Override
    protected void onValidate(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        for (Pair<AbstractExpression, StatementBlock> pair : this.conditionsBlocks) {
            ((AbstractExpression)pair.first).validate(context);
            ((StatementBlock)pair.second).validate(context);
            if (((AbstractExpression)pair.first).getResultType() == TypeFactory.BOOLEAN) continue;
            throw this.initException(new TriggerFunctionException("IF condition should return type BOOLEAN, but returns " + ((AbstractExpression)pair.first).getResultType().getName()), ((AbstractExpression)pair.first).getBeginPosition());
        }
        if (this.elseBlock != null) {
            this.elseBlock.validate(context);
        }
    }

    @Override
    protected void onCompile(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        for (Pair<AbstractExpression, StatementBlock> pair : this.conditionsBlocks) {
            pair.first = ((AbstractExpression)pair.first).compile(context);
            ((StatementBlock)pair.second).compile(context);
        }
        if (this.elseBlock != null) {
            this.elseBlock.compile(context);
        }
    }

    @Override
    public void reset(boolean withTransient) {
        super.reset(withTransient);
        for (Pair<AbstractExpression, StatementBlock> pair : this.conditionsBlocks) {
            ((StatementBlock)pair.second).reset(withTransient);
        }
        if (this.elseBlock != null) {
            this.elseBlock.reset(withTransient);
        }
    }

    @Override
    public void toString(StringBuilder builder) {
        boolean first = true;
        for (Pair<AbstractExpression, StatementBlock> pair : this.conditionsBlocks) {
            if (first) {
                builder.append("if (");
            } else {
                builder.append("else if (");
            }
            first = false;
            ((AbstractExpression)pair.first).toString(builder);
            builder.append(")");
            ((StatementBlock)pair.second).toString(builder);
        }
        if (this.elseBlock != null) {
            builder.append("else");
            this.elseBlock.toString(builder);
        }
    }
}

