/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.statement;

import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionException;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.statement.AbstractRepeatableStatement;
import com.streamscape.sef.evtrigger.function.statement.AbstractStatement;
import com.streamscape.sef.evtrigger.function.statement.Statement;
import com.streamscape.sef.evtrigger.function.statement.StatementBlock;
import com.streamscape.sef.evtrigger.function.statement.TriggerFunctionBreakException;
import com.streamscape.sef.evtrigger.function.statement.TriggerFunctionContinueException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;

public class ForStatement
extends AbstractRepeatableStatement {
    private StatementBlock initBlock;
    private AbstractExpression condition;
    private StatementBlock loopBlock;

    public ForStatement(AbstractStatement parent) {
        super(Statement.StatementType.FOR, parent);
    }

    public void setInitBlock(StatementBlock initBlock) {
        this.initBlock = initBlock;
    }

    public void setCondition(AbstractExpression condition) {
        this.condition = condition;
    }

    public void setLoopBlock(StatementBlock loopBlock) {
        this.loopBlock = loopBlock;
    }

    @Override
    protected void onExecute(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        Object value;
        if (this.initBlock != null) {
            this.initBlock.execute(context);
        }
        while (this.condition == null || !((value = this.condition.evaluateValueType((TriggerFunctionContext)context).value) instanceof Boolean) || ((Boolean)value).booleanValue()) {
            block5: {
                try {
                    if (this.repeatableBlock == null) break block5;
                    this.repeatableBlock.execute(context);
                }
                catch (TriggerFunctionBreakException exception) {
                    break;
                }
                catch (TriggerFunctionContinueException exception) {
                    continue;
                }
            }
            if (this.loopBlock == null) continue;
            this.loopBlock.execute(context);
        }
    }

    @Override
    protected void onValidate(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        if (this.initBlock != null) {
            this.initBlock.validate(context);
        }
        if (this.condition != null) {
            this.condition.validate(context);
            if (this.condition.getResultType() != TypeFactory.BOOLEAN) {
                throw this.initException(new TriggerFunctionException("FOR condition should return type BOOLEAN, but returns " + this.condition.getResultType().getName()), this.condition.getBeginPosition());
            }
        }
        if (this.loopBlock != null) {
            this.loopBlock.validate(context);
        }
        if (this.repeatableBlock != null) {
            this.repeatableBlock.validate(context);
        }
    }

    @Override
    protected void onCompile(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        if (this.initBlock != null) {
            this.initBlock.compile(context);
        }
        if (this.condition != null) {
            this.condition = this.condition.compile(context);
        }
        if (this.loopBlock != null) {
            this.loopBlock.compile(context);
        }
        if (this.repeatableBlock != null) {
            this.repeatableBlock.compile(context);
        }
    }

    @Override
    public void reset(boolean withTransient) {
        super.reset(withTransient);
        if (this.initBlock != null) {
            this.initBlock.reset(withTransient);
        }
        if (this.loopBlock != null) {
            this.loopBlock.reset(withTransient);
        }
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append("for (");
        if (this.initBlock != null) {
            this.initBlock.toString(builder);
        }
        builder.append(";");
        if (this.condition != null) {
            this.condition.toString(builder);
        }
        builder.append(";");
        if (this.loopBlock != null) {
            this.loopBlock.toString(builder);
        }
        builder.append(")");
        if (this.repeatableBlock != null) {
            this.repeatableBlock.toString(builder);
        } else {
            builder.append(";\n");
        }
    }
}

