/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.statement;

import com.streamscape.sef.evtrigger.function.SemanticTypeLookupContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionException;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.statement.AbstractRepeatableStatement;
import com.streamscape.sef.evtrigger.function.statement.AbstractStatement;
import com.streamscape.sef.evtrigger.function.statement.Statement;
import com.streamscape.sef.evtrigger.function.statement.TriggerFunctionBreakException;
import com.streamscape.sef.evtrigger.function.statement.TriggerFunctionContinueException;
import com.streamscape.sef.evtrigger.function.statement.Variable;
import com.streamscape.sef.evtrigger.function.types.ArrayType;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import java.util.Collection;

public class ForEachStatement
extends AbstractRepeatableStatement {
    private Variable variable;
    private AbstractExpression iterableExpression;

    public ForEachStatement(AbstractStatement parent, Variable variable, AbstractExpression iterableExpression) {
        super(Statement.StatementType.FOREACH, parent);
        this.variable = variable;
        this.iterableExpression = iterableExpression;
    }

    @Override
    protected void onExecute(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        Expression.ValueTypeResult result = this.iterableExpression.evaluateValueType(context);
        if (result.value == null) {
            throw this.initException(new TriggerFunctionException("Failed to iterate null value."), this.iterableExpression.getBeginPosition());
        }
        Class<?> valueClass = result.value.getClass();
        if (result.type.getType() == Types.ARRAY && valueClass.isArray()) {
            Object[] arrayValue;
            for (Object value : arrayValue = (Object[])result.value) {
                try {
                    this.variable.assignValue(value, ((ArrayType)result.type).getElementType(), context);
                }
                catch (ValueConversionException exception) {
                    throw this.initException(new TriggerFunctionException(exception.getMessage(), exception));
                }
                try {
                    this.repeatableBlock.execute(context);
                }
                catch (TriggerFunctionBreakException exception) {
                    break;
                }
                catch (TriggerFunctionContinueException exception) {
                    // empty catch block
                }
            }
        } else if (Collection.class.isAssignableFrom(valueClass)) {
            Collection collectionValue = (Collection)result.value;
            for (Object value : collectionValue) {
                try {
                    this.variable.assignValue(value, value != null ? TypeFactory.resolveType(value.getClass(), (SemanticTypeLookupContext)context) : TypeFactory.NULLTYPE, context);
                }
                catch (ValueConversionException exception) {
                    throw this.initException(new TriggerFunctionException(exception.getMessage(), exception));
                }
                try {
                    this.repeatableBlock.execute(context);
                }
                catch (TriggerFunctionBreakException exception) {
                    break;
                }
                catch (TriggerFunctionContinueException exception) {
                }
            }
        } else {
            throw this.initException(new TriggerFunctionException("Failed to iterate valriable of type '" + result.type.getName() + "'."));
        }
    }

    @Override
    protected void onValidate(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        this.iterableExpression = this.iterableExpression.compile(context);
        this.repeatableBlock.validate(context);
        try {
            this.iterableExpression.getResultType().validateIterate(this.variable.getType());
        }
        catch (TriggerFunctionException exception) {
            throw this.initException(exception, this.iterableExpression.getBeginPosition());
        }
    }

    @Override
    protected void onCompile(TriggerFunctionContext context) throws ExpressionExecutionException, TriggerFunctionException {
        this.iterableExpression = this.iterableExpression.compile(context);
        this.repeatableBlock.compile(context);
    }

    @Override
    public void reset(boolean withTransient) {
        super.reset(withTransient);
        this.variable.reset(withTransient);
    }

    @Override
    public void toString(StringBuilder builder) {
        builder.append("for (");
        builder.append(this.variable.getType().getName()).append(" ").append(this.variable.getName());
        builder.append(":");
        this.iterableExpression.toString(builder);
        builder.append(")");
        this.repeatableBlock.toString(builder);
    }
}

