/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.statement;

import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionDisableException;
import com.streamscape.sef.evtrigger.function.TriggerFunctionException;
import com.streamscape.sef.evtrigger.function.TriggerFunctionInvalidateException;
import com.streamscape.sef.evtrigger.function.expression.DisableExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.InvalidateExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.statement.AbstractStatement;
import com.streamscape.sef.evtrigger.function.statement.Statement;
import com.streamscape.sef.evtrigger.function.statement.StatementResult;
import com.streamscape.tools.lexer.BufferUtils;

public abstract class AbstractStatementWithErrorHandling
extends AbstractStatement {
    protected AbstractStatementWithErrorHandling(Statement.StatementType type, AbstractStatement parent) {
        super(type, parent);
    }

    @Override
    public StatementResult execute(TriggerFunctionContext context) throws TriggerFunctionException {
        try {
            this.onExecute(context);
        }
        catch (ExpressionExecutionException exception) {
            throw this.convertExpressionExecutionException(exception);
        }
        return StatementResult.OK;
    }

    @Override
    public void validate(TriggerFunctionContext context) throws TriggerFunctionException {
        try {
            this.onValidate(context);
        }
        catch (ExpressionExecutionException exception) {
            throw this.convertExpressionExecutionException(exception);
        }
    }

    @Override
    public void compile(TriggerFunctionContext context) throws TriggerFunctionException {
        try {
            this.onCompile(context);
        }
        catch (ExpressionExecutionException exception) {
            throw this.convertExpressionExecutionException(exception);
        }
    }

    protected abstract void onExecute(TriggerFunctionContext var1) throws ExpressionExecutionException, TriggerFunctionException;

    protected abstract void onValidate(TriggerFunctionContext var1) throws ExpressionExecutionException, TriggerFunctionException;

    protected abstract void onCompile(TriggerFunctionContext var1) throws ExpressionExecutionException, TriggerFunctionException;

    protected TriggerFunctionException convertExpressionExecutionException(ExpressionExecutionException exception) {
        TriggerFunctionException triggerException = exception instanceof InvalidateExpressionExecutionException ? new TriggerFunctionInvalidateException(exception.getMessage()) : (exception instanceof DisableExpressionExecutionException ? new TriggerFunctionDisableException() : new TriggerFunctionException(exception.getMessage(), exception));
        this.initException(triggerException, exception.getExpression().getBeginPosition());
        return triggerException;
    }

    protected TriggerFunctionException initException(TriggerFunctionException exception) {
        return this.initException(exception, this.getBeginPosition());
    }

    protected TriggerFunctionException initException(TriggerFunctionException exception, int position) {
        if (position != -1) {
            BufferUtils.setLineAndPositions(exception, this.getStatementContext().getScript(), position);
        }
        return exception;
    }
}

