/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.fields.event;

import com.streamscape.Trace;
import com.streamscape.ds.parser.completion.EventPropertiesCompleter;
import com.streamscape.repository.types.Prototype;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.EventDatagramWithProperties;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.PayloadEvent;
import com.streamscape.sdo.enums.PropertyType;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.SemanticTypeLookupContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.AbstractTransactionalValueAccessor;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.AssignableExpression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.fields.FieldAccessorByMethodExpression;
import com.streamscape.sef.evtrigger.function.fields.SpecificFieldAccessorsManager;
import com.streamscape.sef.evtrigger.function.fields.event.EventSpecificFieldAccessors;
import com.streamscape.sef.evtrigger.function.types.EventType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import com.streamscape.slex.lang.completion.DSLCompletion;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class EventValueAccessorExpression
extends AbstractExpression
implements AssignableExpression {
    private AbstractExpression parentExpression;
    private String propertyName;
    private static final Method GET_PROPERTY_METHOD;
    private static final Method SET_PROPERTY_METHOD;
    private static final Method EXISTS_PROPERTY_METHOD;
    private static final Method GET_PROPERTY_TYPE_METHOD;
    private static final Method GET_PROPERTY_NAMES_METHOD;

    public EventValueAccessorExpression(AbstractExpression parentExpression, String propertyName) {
        this(parentExpression, propertyName, false);
    }

    public EventValueAccessorExpression(AbstractExpression parentExpression, String propertyName, boolean forComplete) {
        super(Priority.PRIORITY1);
        this.parentExpression = parentExpression;
        this.propertyName = forComplete ? propertyName : EventSpecificFieldAccessors.resolveAlias(propertyName);
        this.setResultType(TypeFactory.createObjectType());
    }

    @Override
    public ValueAccessor evaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
        ValueAccessor parentValueAccessor = this.parentExpression.evaluate(context);
        ValueAccessor accessor = EventSpecificFieldAccessors.getSpecificFieldAccessorsManager().getSpecificFieldAccessor(parentValueAccessor, this.propertyName, context);
        if (accessor != null) {
            try {
                accessor.resolveType(context);
                this.setResultType(accessor.getType());
            }
            catch (TypeConversionException exception) {
                throw new ExpressionExecutionException(exception.getMessage(), this, exception);
            }
        }
        if (accessor == null) {
            try {
                FieldAccessorByMethodExpression methodAccessorExpression = new FieldAccessorByMethodExpression(this.parentExpression, this.propertyName);
                methodAccessorExpression.compile(context);
                accessor = methodAccessorExpression.evaluate(context);
            }
            catch (ExpressionExecutionException exception) {
                this.checkTypeIsEventDatagramWithProperties(context, (EventType)parentValueAccessor.getType(), exception);
            }
        }
        if (accessor == null) {
            accessor = new EventPropertyValueAccessor(parentValueAccessor);
        }
        return accessor;
    }

    @Override
    protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
        this.validateInternal(context, true);
        return this;
    }

    @Override
    public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
        this.validateInternal(context, false);
    }

    private void validateInternal(TriggerFunctionContext context, boolean isCompile) throws ExpressionExecutionException {
        SpecificFieldAccessorsManager.SpecificFieldAccessor accessor;
        this.parentExpression.validate(context);
        EventType eventType = (EventType)this.parentExpression.getResultType();
        if (eventType.getSemanticTypeName() == null || eventType.getSemanticTypeClassName() == null) {
            if (isCompile) {
                return;
            }
            try {
                eventType.resolveEventType(context);
            }
            catch (Exception exception) {
                throw new ExpressionExecutionException("Resolving of event [" + eventType.getEventId() + "] failed. Cause: " + exception.getMessage(), this, exception);
            }
        }
        if ((accessor = EventSpecificFieldAccessors.getSpecificFieldAccessorsManager().getSpecificFieldAccessor(eventType, this.propertyName, context)) != null) {
            try {
                accessor.resolveType(context);
            }
            catch (TypeConversionException exception) {
                throw new ExpressionExecutionException(exception.getMessage(), this, exception);
            }
            this.setResultType(accessor.getType());
            return;
        }
        try {
            FieldAccessorByMethodExpression methodAccessorExpression = new FieldAccessorByMethodExpression(this.parentExpression, this.propertyName);
            methodAccessorExpression.compile(context);
            this.setResultType(methodAccessorExpression.getResultType());
            this.setResultType(EventValueAccessorExpression.resolvePayloadType(context, eventType, this.propertyName, this.getResultType()));
            return;
        }
        catch (ExpressionExecutionException exception) {
            this.checkTypeIsEventDatagramWithProperties(context, eventType, exception);
            try {
                ImmutableEventDatagram event = context.createEvent(eventType.getEventId());
                if (event == null) {
                    throw new ExpressionExecutionException("Creation of event [" + eventType.getEventId() + "] failed. Cause: Event prototype does not exist.", this);
                }
                this.checkPropertyExists(event);
                this.resolvePropertyType(event);
            }
            catch (DatagramFactoryException exception2) {
                throw new ExpressionExecutionException("Creation of event [" + eventType.getEventId() + "] failed. Cause: " + exception2.getMessage(), this, exception2);
            }
            catch (ValueConversionException exception3) {
                throw new ExpressionExecutionException(exception3.getMessage(), this, exception3);
            }
            return;
        }
    }

    public static Type<?> resolvePayloadType(TriggerFunctionContext context, EventType eventType, String name, Type<?> oldType) {
        if (!(("DataEvent".equals(eventType.getSemanticTypeName()) || "OpaqueEvent".equals(eventType.getSemanticTypeName())) && (name.equals("data") || name.equals("getData")) || "DeltaEvent".equals(eventType.getSemanticTypeName()) && (name.equals("beforeImage") || name.equals("afterImage") || name.equals("getBeforeImage") || name.equals("getAfterImage")))) {
            return oldType;
        }
        Prototype prototype = context.lookupEventPrototype(eventType.getEventId());
        if (prototype != null) {
            try {
                EventDatagram event = context.getEventDatagramFactory().createEvent(prototype);
                if (event instanceof PayloadEvent) {
                    return TypeFactory.resolveType(((PayloadEvent)((Object)event)).getPayloadClass(), (SemanticTypeLookupContext)context);
                }
            }
            catch (DatagramFactoryException exception) {
                Trace.logError(EventValueAccessorExpression.class, "Failed to create event [" + eventType.getEventId() + "].");
            }
        }
        return oldType;
    }

    protected void checkTypeIsEventDatagramWithProperties(TriggerFunctionContext context, EventType eventType, ExpressionExecutionException exception) throws ExpressionExecutionException {
        try {
            if (eventType.getSemanticTypeClassName() == null) {
                throw new ExpressionExecutionException("Type of field '" + this.parentExpression.toString() + "' not defined.", this);
            }
            Class<?> eventClass = context.loadClass(eventType.getSemanticTypeClassName());
            if (!EventDatagramWithProperties.class.isAssignableFrom(eventClass)) {
                throw exception;
            }
        }
        catch (ClassNotFoundException exception1) {
            throw exception;
        }
    }

    @Override
    public DSLCompletion complete(TriggerFunctionContext context) throws ExpressionExecutionException {
        this.parentExpression.validate(context);
        EventType eventType = (EventType)this.parentExpression.getResultType();
        if (eventType == null || eventType.getEventId() == null && eventType.getSemanticTypeClassName() == null) {
            throw new ExpressionExecutionException("Event Id and event type is not set.", this);
        }
        ImmutableEventDatagram event = null;
        Class eventClass = null;
        if (eventType.getSemanticTypeClassName() != null && eventType.getSemanticTypeClassName().equals(AcknowledgementEvent.class.getName())) {
            eventClass = AcknowledgementEvent.class;
        } else {
            if (eventType.getEventId() == null) {
                try {
                    eventClass = context.loadClass(eventType.getSemanticTypeClassName());
                }
                catch (ClassNotFoundException exception) {
                    throw new ExpressionExecutionException("Creation of event class '" + eventType.getSemanticTypeClassName() + " failed.", this, exception);
                }
            }
            try {
                event = context.createEvent(eventType.getEventId());
            }
            catch (DatagramFactoryException exception) {
                throw new ExpressionExecutionException("Creation of event [" + eventType.getEventId() + "] failed. Cause: " + exception.getMessage(), this, exception);
            }
            if (event == null) {
                throw new ExpressionExecutionException("Creation of event [" + eventType.getEventId() + "] failed. Cause: Event prototype does not exist.", this);
            }
            eventClass = event.getClass();
        }
        return new EventPropertiesCompleter(eventClass, event, context).complete(this.propertyName);
    }

    @Override
    protected void onToString(StringBuilder builder) {
        builder.append(this.parentExpression.toString()).append(".").append(this.propertyName);
    }

    protected void checkPropertyExists(Object event) throws ValueConversionException {
        try {
            if (!((Boolean)EXISTS_PROPERTY_METHOD.invoke(event, this.propertyName)).booleanValue()) {
                throw new ValueConversionException("Property '" + this.propertyName + "' does not exist in object '" + this.parentExpression.toString() + "' of type '" + String.valueOf(this.parentExpression.getResultType()) + "'.");
            }
        }
        catch (ValueConversionException exception) {
            throw exception;
        }
        catch (InvocationTargetException exception) {
            throw new ValueConversionException("Accessing property '" + this.propertyName + "' failed.", exception.getCause());
        }
        catch (Exception exception) {
            throw new ValueConversionException("Accessing property '" + this.propertyName + "' failed.", exception);
        }
    }

    protected void resolvePropertyType(Object event) throws ValueConversionException {
        try {
            PropertyType propertyType = (PropertyType)((Object)GET_PROPERTY_TYPE_METHOD.invoke(event, this.propertyName));
            if (propertyType != null) {
                this.setResultType(TypeFactory.convertFromEventPropertyType(propertyType, GET_PROPERTY_METHOD.invoke(event, this.propertyName)));
            }
        }
        catch (InvocationTargetException exception) {
            throw new ValueConversionException("Accessing property '" + this.propertyName + "' failed.", exception.getCause());
        }
        catch (Exception exception) {
            throw new ValueConversionException("Accessing property '" + this.propertyName + "' failed.", exception);
        }
    }

    static {
        try {
            GET_PROPERTY_METHOD = EventDatagramWithProperties.class.getMethod("getEventObjectProperty", String.class);
            SET_PROPERTY_METHOD = EventDatagramWithProperties.class.getMethod("setEventObjectProperty", String.class, Object.class);
            EXISTS_PROPERTY_METHOD = EventDatagramWithProperties.class.getMethod("existsEventProperty", String.class);
            GET_PROPERTY_TYPE_METHOD = EventDatagramWithProperties.class.getMethod("getEventPropertyType", String.class);
            GET_PROPERTY_NAMES_METHOD = EventDatagramWithProperties.class.getMethod("getEventPropertyNames", new Class[0]);
            GET_PROPERTY_METHOD.setAccessible(true);
            SET_PROPERTY_METHOD.setAccessible(true);
            EXISTS_PROPERTY_METHOD.setAccessible(true);
            GET_PROPERTY_TYPE_METHOD.setAccessible(true);
            GET_PROPERTY_NAMES_METHOD.setAccessible(true);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected class EventPropertyValueAccessor
    extends AbstractTransactionalValueAccessor {
        EventPropertyValueAccessor(ValueAccessor parentValueAccessor) {
            super(parentValueAccessor);
        }

        @Override
        public Type<?> getType() {
            return EventValueAccessorExpression.this.getResultType();
        }

        @Override
        protected void resolveTypeInRuntime(TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
            Object event = this.parentValueAccessor.getValue(context);
            if (event == null) {
                return;
            }
            EventValueAccessorExpression.this.checkPropertyExists(event);
            EventValueAccessorExpression.this.resolvePropertyType(event);
        }

        @Override
        protected Object onGetValue(TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
            Object event = this.parentValueAccessor.getValue(context);
            if (event == null) {
                throw new ExpressionExecutionException("Obtaining property '" + EventValueAccessorExpression.this.propertyName + "' failed on null event [" + this.parentValueAccessor.toString() + "].", EventValueAccessorExpression.this.parentExpression);
            }
            try {
                return GET_PROPERTY_METHOD.invoke(event, EventValueAccessorExpression.this.propertyName);
            }
            catch (InvocationTargetException exception) {
                throw new ValueConversionException("Obtaining property '" + EventValueAccessorExpression.this.propertyName + "' failed.", exception.getCause());
            }
            catch (Exception exception) {
                throw new ValueConversionException("Obtaining property '" + EventValueAccessorExpression.this.propertyName + "' failed.", exception);
            }
        }

        @Override
        protected void onAssignValue(Object value, Type<?> valueType, TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
            Object event = this.parentValueAccessor.getValue(context);
            if (event == null) {
                throw new ExpressionExecutionException("Setting property '" + EventValueAccessorExpression.this.propertyName + "' failed on null event [" + this.parentValueAccessor.toString() + "].", EventValueAccessorExpression.this.parentExpression);
            }
            try {
                value = this.getType().convertValue(value, valueType);
                SET_PROPERTY_METHOD.invoke(event, EventValueAccessorExpression.this.propertyName, value);
            }
            catch (ValueConversionException exception) {
                throw exception;
            }
            catch (InvocationTargetException exception) {
                throw new ValueConversionException("Setting property '" + EventValueAccessorExpression.this.propertyName + "' failed.", exception.getCause());
            }
            catch (Exception exception) {
                throw new ValueConversionException("Setting property '" + EventValueAccessorExpression.this.propertyName + "' failed.", exception);
            }
        }

        @Override
        public String toString() {
            return this.parentValueAccessor.toString() + "." + EventValueAccessorExpression.this.propertyName;
        }
    }
}

