/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.fields;

import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.sef.evtrigger.function.SemanticTypeLookupContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

class ValueAccessorByMethodHelper {
    private Class<?> clazz;
    private Class<?> valueType;
    private String fieldName;
    private String setMethodName;
    private String getMethodName;
    private Type<?> type;
    private Method setMethod;
    private Method getMethod;
    private boolean useJavaMethodAccessRights = true;

    ValueAccessorByMethodHelper(Class<?> clazz, String fieldName, Class<?> valueType, String getMethodName, String setMethodName) {
        this.clazz = clazz;
        this.valueType = valueType;
        this.fieldName = fieldName;
        this.setMethodName = setMethodName;
        this.getMethodName = getMethodName;
        this.setUseJavaMethodAccessRights(true);
    }

    public void resolveMethods(TriggerFunctionContext context) throws TypeConversionException {
        this.type = TypeFactory.resolveType(this.valueType, (SemanticTypeLookupContext)context);
        if (this.setMethodName != null) {
            this.setMethod = ClassUtils.getDeclaredOrInheritedMethod(this.clazz, this.setMethodName, new Class[]{this.valueType}, false);
        }
        if (this.getMethodName != null) {
            this.getMethod = ClassUtils.getDeclaredOrInheritedMethod(this.clazz, this.getMethodName, new Class[0], false);
        }
        if (this.setMethod == null && (this.getMethod == null || this.getMethod.getReturnType() != this.valueType)) {
            throw new TypeConversionException("There are no get/set methods found for field '" + this.fieldName + "'.");
        }
    }

    public Object onGetValue(ValueAccessor parentValueAccessor, TriggerFunctionContext context) throws ValueConversionException, ExpressionExecutionException {
        if (this.getMethod == null) {
            throw new ValueConversionException("There is no get method for field '" + this.fieldName + "' in object '" + parentValueAccessor.toString() + "'.");
        }
        if (this.isUseJavaMethodAccessRights() && !Modifier.isPublic(this.getMethod.getModifiers()) || this.getMethod == null) {
            throw new ValueConversionException("There is no rights to get '" + this.fieldName + "' in object '" + parentValueAccessor.toString() + "'.");
        }
        this.getMethod.setAccessible(true);
        Object parentValue = parentValueAccessor.getValue(context);
        if (parentValue == null) {
            throw new ValueConversionException("Failed to access field '" + this.fieldName + "' in null object '" + parentValueAccessor.toString() + "'.");
        }
        try {
            return this.getMethod.invoke(parentValue, new Object[0]);
        }
        catch (Exception exception) {
            throw new ValueConversionException("Failed to access field '" + this.fieldName + "' by calling method '" + this.getMethodName + "' in object '" + parentValueAccessor.toString() + "' of type '" + String.valueOf(parentValue.getClass()) + "'. Cause: " + exception.getMessage());
        }
    }

    public void onAssign(ValueAccessor parentValueAccessor, Object value, Type<?> valueType, TriggerFunctionContext context) throws ValueConversionException, ExpressionExecutionException {
        if (this.setMethod == null) {
            throw new ValueConversionException("There is no set method for field '" + this.fieldName + "' in object '" + parentValueAccessor.toString() + "'.");
        }
        if (this.isUseJavaMethodAccessRights() && !Modifier.isPublic(this.setMethod.getModifiers()) || this.setMethod == null) {
            throw new ValueConversionException("There are no rights to set '" + this.fieldName + "' in object '" + parentValueAccessor.toString() + "'.");
        }
        this.setMethod.setAccessible(true);
        Object parentValue = parentValueAccessor.getValue(context);
        if (parentValue == null) {
            throw new ValueConversionException("Failed to set field '" + this.fieldName + "' in null object '" + parentValueAccessor.toString() + "'.");
        }
        try {
            this.setMethod.invoke(parentValue, TypeFactory.wrapUnwrapValue(this.setMethod.getParameterTypes()[0], this.type.convertValue(value, valueType)));
        }
        catch (ValueConversionException exception) {
            throw exception;
        }
        catch (Throwable exception) {
            if (exception instanceof InvocationTargetException) {
                exception = exception.getCause();
            }
            throw new ValueConversionException("Failed to set field '" + this.fieldName + "' in object '" + parentValueAccessor.toString() + ". Cause: " + exception.getMessage());
        }
    }

    public boolean isUseJavaMethodAccessRights() {
        return this.useJavaMethodAccessRights;
    }

    public void setUseJavaMethodAccessRights(boolean useJavaMethodAccessRights) {
        this.useJavaMethodAccessRights = useJavaMethodAccessRights;
    }

    public boolean needToReload(TriggerFunctionContext context) {
        return context.needToReload(this.clazz) || context.needToReload(this.valueType) || context.needToReload(this.setMethod) || context.needToReload(this.getMethod);
    }
}

