/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.fields;

import com.streamscape.sef.evtrigger.function.SemanticTypeLookupContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.AbstractTransactionalValueAccessor;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.fields.ValueAccessorByMethodHelper;
import com.streamscape.sef.evtrigger.function.types.AbstractObjectType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpecificFieldAccessorsManager {
    private Map<String, List<SpecificFieldInfo>> specificFields = new HashMap<String, List<SpecificFieldInfo>>();

    public void registerSpecificField(Class<?> clazz, String fieldName, Class<?> fieldType, String getMethod, String setMethod) throws Exception {
        if (setMethod != null && clazz.getMethod(setMethod, fieldType) == null) {
            throw new Exception("Class '" + clazz.getName() + "' doesn't contain method '" + setMethod + "' with argument of type '" + fieldType.getName() + "'.");
        }
        if (getMethod != null && clazz.getMethod(getMethod, new Class[0]) == null) {
            throw new Exception("Class '" + clazz.getName() + "' doesn't contain method '" + getMethod + "'.");
        }
        if (getMethod != null && clazz.getMethod(getMethod, new Class[0]).getReturnType() != fieldType) {
            throw new Exception("Class '" + clazz.getName() + "' doesn't contain method '" + getMethod + "' with return type '" + fieldType.getName() + "'.");
        }
        List<SpecificFieldInfo> list = this.specificFields.get(fieldName);
        if (list == null) {
            list = new ArrayList<SpecificFieldInfo>();
            this.specificFields.put(fieldName, list);
        }
        for (SpecificFieldInfo info : list) {
            if (info.clazz != clazz) continue;
            throw new Exception("Duplicate specific field '" + fieldName + "' in class '" + clazz.getName() + "'. Field already registered for class '" + info.clazz.getName() + "'.");
        }
        SpecificFieldInfo info = new SpecificFieldInfo();
        info.clazz = clazz;
        info.fieldName = fieldName;
        info.fieldType = fieldType;
        info.getMethod = getMethod;
        info.setMethod = setMethod;
        list.add(info);
    }

    protected SpecificFieldInfo lookupSpecificFieldInfo(Type<?> parentType, String fieldName, TriggerFunctionContext context) {
        String parentClassName;
        if (parentType instanceof AbstractObjectType && (parentClassName = ((AbstractObjectType)parentType).getSemanticTypeClassName()) != null) {
            Class<?> parentClass;
            try {
                parentClass = context.loadClass(parentClassName);
            }
            catch (ClassNotFoundException exception) {
                return null;
            }
            return this.lookupSpecificFieldsByFieldNameAndClass(fieldName, parentClass);
        }
        return null;
    }

    public boolean existsSpecificFieldAccessor(Type<?> parentType, String fieldName, TriggerFunctionContext context) {
        return this.lookupSpecificFieldInfo(parentType, fieldName, context) != null;
    }

    public SpecificFieldAccessor getSpecificFieldAccessor(Type<?> parentType, String fieldName, TriggerFunctionContext context) {
        SpecificFieldInfo info = this.lookupSpecificFieldInfo(parentType, fieldName, context);
        if (info == null) {
            return null;
        }
        return new SpecificFieldAccessor(info);
    }

    public SpecificFieldAccessor getSpecificFieldAccessor(ValueAccessor parentValueAccessor, String fieldName, TriggerFunctionContext context) {
        SpecificFieldAccessor accessor = this.getSpecificFieldAccessor(parentValueAccessor.getType(), fieldName, context);
        if (accessor != null) {
            accessor.setParentValueAccessor(parentValueAccessor);
        }
        return accessor;
    }

    public List<SpecificFieldInfo> listSpecificFieldsFor(Class<?> clazz) {
        ArrayList<SpecificFieldInfo> result = new ArrayList<SpecificFieldInfo>();
        for (List<SpecificFieldInfo> l : this.specificFields.values()) {
            for (SpecificFieldInfo info : l) {
                if (!info.clazz.isAssignableFrom(clazz)) continue;
                result.add(info);
            }
        }
        return result;
    }

    public SpecificFieldInfo lookupSpecificFieldsByFieldNameAndClass(String fieldName, Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        List<SpecificFieldInfo> list = this.specificFields.get(fieldName);
        if (list != null && list.size() > 0) {
            for (SpecificFieldInfo info : list) {
                if (!info.clazz.isAssignableFrom(clazz)) continue;
                return info;
            }
        }
        return null;
    }

    public static class SpecificFieldInfo {
        public Class<?> clazz;
        public String fieldName;
        public Class<?> fieldType;
        public String getMethod;
        public String setMethod;
    }

    public static class SpecificFieldAccessor
    extends AbstractTransactionalValueAccessor {
        private SpecificFieldInfo info;
        private Type<?> type;
        private ValueAccessorByMethodHelper valueAccessorByMethodHelper;

        SpecificFieldAccessor(SpecificFieldInfo info) {
            super(null);
            this.info = info;
        }

        public void setParentValueAccessor(ValueAccessor parentValueAccessor) {
            this.parentValueAccessor = parentValueAccessor;
        }

        public void resolveType(TriggerFunctionContext context) throws TypeConversionException {
            this.setType(TypeFactory.resolveType(this.info.fieldType, (SemanticTypeLookupContext)context));
            this.valueAccessorByMethodHelper = new ValueAccessorByMethodHelper(this.info.clazz, this.info.fieldName, this.info.fieldType, this.info.getMethod, this.info.setMethod);
            this.valueAccessorByMethodHelper.resolveMethods(context);
        }

        @Override
        protected Object onGetValue(TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
            return this.valueAccessorByMethodHelper.onGetValue(this.parentValueAccessor, context);
        }

        @Override
        protected void onAssignValue(Object value, Type<?> valueType, TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
            this.valueAccessorByMethodHelper.onAssign(this.parentValueAccessor, value, valueType, context);
        }

        @Override
        public Type<?> getType() {
            return this.type;
        }

        protected void setType(Type<?> type) {
            this.type = type;
        }

        @Override
        protected void resolveTypeInRuntime(TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
        }

        @Override
        public String toString() {
            return this.parentValueAccessor.toString() + "." + this.info.fieldName;
        }
    }
}

