/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.fields;

import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ReadOnlyValueAccessor;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.types.ArrayType;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.Types;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public class NewExpression
extends AbstractExpression {
    private String typeName;
    protected List<AbstractExpression> arguments = new ArrayList<AbstractExpression>();
    protected Class<?>[] argumentTypes;
    protected boolean unwrappBytesArray = false;
    protected AbstractExpression arraySizeExpression = null;

    public NewExpression(String typeName) {
        super(Priority.PRIORITY14);
        this.typeName = typeName;
    }

    public void setArguments(List<AbstractExpression> arguments) {
        this.arguments = arguments;
    }

    public void setArraySizeExpression(AbstractExpression arraySizeExpression) {
        this.arraySizeExpression = arraySizeExpression;
    }

    @Override
    public ValueAccessor evaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
        try {
            Class<?> clazz = TypeFactory.resolveClass(this.getResultType(), context);
            if (clazz == null) {
                throw new ExpressionExecutionException("Failed to load class '" + this.getResultType().getName() + "'.", this);
            }
            if (this.arraySizeExpression == null) {
                Object[] argumentValues = new Object[this.arguments.size()];
                for (int i = 0; i < this.arguments.size(); ++i) {
                    argumentValues[i] = this.arguments.get((int)i).evaluateValueType((TriggerFunctionContext)context).value;
                    if (this.unwrappBytesArray && argumentValues[i] != null && argumentValues[i].getClass() == Byte[].class) {
                        argumentValues[i] = TypeFactory.unwrapBoxerValue(argumentValues[i]);
                    }
                    if (argumentValues[i] == null) continue;
                    this.argumentTypes[i] = argumentValues[i].getClass();
                }
                Constructor constructor = ClassUtils.getSatisfiableConstructor(clazz, this.argumentTypes);
                if (constructor == null) {
                    throw new ExpressionExecutionException("Constructor with specified arguments not found.", this);
                }
                constructor.setAccessible(true);
                return new ReadOnlyValueAccessor(constructor.newInstance(argumentValues), this.getResultType());
            }
            Expression.ValueTypeResult arraySize = this.arraySizeExpression.evaluateValueType(context);
            if (!clazz.isArray()) {
                throw new ExpressionExecutionException("Wrong class '" + clazz.getName() + "' for array type '" + this.getResultType().getName() + "'.", this);
            }
            return new ReadOnlyValueAccessor(Array.newInstance(clazz.getComponentType(), (int)TypeFactory.INT.convertValue(arraySize.value, arraySize.type)), this.getResultType());
        }
        catch (ExpressionExecutionException exception) {
            throw exception;
        }
        catch (ClassNotFoundException exception) {
            throw new ExpressionExecutionException("Failed to create instance of type '" + this.getResultType().getName() + "'. Cause: Type is not loaded.", this, exception);
        }
        catch (Exception exception) {
            throw new ExpressionExecutionException("Failed to create instance of type '" + this.getResultType().getName() + "'. Cause: " + exception.getMessage(), this, exception);
        }
    }

    @Override
    protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
        for (int i = 0; i < this.arguments.size(); ++i) {
            this.arguments.set(i, this.arguments.get(i).compile(context));
        }
        if (this.arraySizeExpression != null) {
            this.arraySizeExpression = this.arraySizeExpression.compile(context);
            try {
                TypeFactory.INT.canConvert(this.arraySizeExpression.getResultType());
            }
            catch (TypeConversionException exception) {
                throw new ExpressionExecutionException(exception.getMessage(), this.arraySizeExpression, exception);
            }
        }
        Class<?> clazz = null;
        try {
            ArrayType type = TypeFactory.createType(this.typeName, context);
            if (type == null) {
                throw new ExpressionExecutionException("Type '" + this.typeName + "' not found.", this);
            }
            if (type == TypeFactory.COLLECTION) {
                throw new ExpressionExecutionException("Creation of instance of type 'Collection' not allowed.", this);
            }
            if (type != null && type.getType() == Types.ENTRY) {
                throw new ExpressionExecutionException("Creation of instance of type 'MapEntry' not allowed.", this);
            }
            if (this.arraySizeExpression != null) {
                type = TypeFactory.createArrayType(type);
            }
            this.setResultType(type);
            if (this.getResultType() == null) {
                throw new ExpressionExecutionException("Failed to load object of type '" + this.typeName + "'. Type doesn't exist.", this);
            }
            clazz = TypeFactory.resolveClass(this.getResultType(), context);
            if (clazz == null) {
                throw new ExpressionExecutionException("Failed to load class '" + this.getResultType().getName() + "'.", this);
            }
        }
        catch (ClassNotFoundException exception) {
            throw new ExpressionExecutionException("Failed to load object of type '" + this.typeName + "'. Cause: Type is not loaded.", this, exception);
        }
        if (this.arraySizeExpression == null && this.getSatisfiableConstructor(context, clazz, false) == null) {
            if (this.getSatisfiableConstructor(context, clazz, true) == null) {
                throw new ExpressionExecutionException("Constructor with specified arguments not found.", this);
            }
            this.unwrappBytesArray = true;
        }
        return this;
    }

    private Constructor<?> getSatisfiableConstructor(TriggerFunctionContext context, Class<?> clazz, boolean unwrappBytesArray) throws ExpressionExecutionException {
        this.argumentTypes = new Class[this.arguments.size()];
        for (int i = 0; i < this.arguments.size(); ++i) {
            try {
                this.argumentTypes[i] = TypeFactory.resolveClass(this.arguments.get(i).getResultType(), context);
                if (!unwrappBytesArray || this.argumentTypes[i] == null || this.argumentTypes[i] != Byte[].class) continue;
                this.argumentTypes[i] = byte[].class;
                continue;
            }
            catch (ClassNotFoundException exception) {
                throw new ExpressionExecutionException("Failed to load object of type '" + this.arguments.get(i).getResultType().getName() + "'.", this, exception);
            }
        }
        return ClassUtils.getSatisfiableConstructor(clazz, this.argumentTypes);
    }

    @Override
    public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
    }

    @Override
    protected void onToString(StringBuilder builder) {
        builder.append("new ");
        if (this.arraySizeExpression == null) {
            builder.append(this.getResultType() != null ? this.getResultType().getName() : this.typeName);
            builder.append("(");
            for (int i = 0; i < this.arguments.size(); ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                this.arguments.get(i).toString(builder);
            }
            builder.append(")");
        } else {
            builder.append(this.getResultType() != null ? ((ArrayType)this.getResultType()).getElementType().getName() : this.typeName);
            builder.append("[");
            this.arraySizeExpression.toString(builder);
            builder.append("]");
        }
    }
}

