/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.fields;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.repository.types.Prototype;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ReadOnlyValueAccessor;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.types.AbstractObjectType;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;

public class NewEventExpression
extends AbstractExpression {
    private String eventId;

    public NewEventExpression(String eventId) {
        super(Priority.PRIORITY14);
        this.eventId = eventId;
        this.setResultType(TypeFactory.createEventType());
    }

    public AbstractObjectType<?> getObjectResultType() {
        return (AbstractObjectType)this.getResultType();
    }

    @Override
    public ValueAccessor evaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
        Prototype prototype = context.lookupEventPrototype(this.eventId);
        if (prototype == null) {
            throw new ExpressionExecutionException("Event prototype [" + this.eventId + "] does not exist.", this);
        }
        try {
            return new ReadOnlyValueAccessor(context.createEvent(this.eventId), this.getResultType());
        }
        catch (DatagramFactoryException exception) {
            throw new ExpressionExecutionException("Creation of event [" + this.eventId + "] failed. Cause: " + exception.getMessage(), this, exception);
        }
    }

    @Override
    public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
        try {
            this.setResultType(TypeFactory.createEventType(context, this.eventId));
        }
        catch (Exception exception) {
            throw new ExpressionExecutionException(exception.getMessage(), this, exception);
        }
    }

    @Override
    protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
        if (!StringUtils.validateEventId(this.eventId)) {
            throw new ExpressionExecutionException("Invalid event id [" + this.eventId + "].", this);
        }
        this.setResultType(TypeFactory.createEventType(this.eventId));
        this.getParentBlock().getStatementContext().addUsedEventId(this.eventId);
        return this;
    }

    @Override
    protected void onToString(StringBuilder builder) {
        builder.append("new ").append("[").append(this.eventId).append("]");
    }
}

