/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.fields;

import com.streamscape.Trace;
import com.streamscape.ds.parser.completion.MethodCompleter;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.SemanticTypeLookupContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.AbstractTransactionalValueAccessor;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.AssignableExpression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.fields.event.EventValueAccessorExpression;
import com.streamscape.sef.evtrigger.function.types.AbstractObjectType;
import com.streamscape.sef.evtrigger.function.types.EventType;
import com.streamscape.sef.evtrigger.function.types.ObjectType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import com.streamscape.slex.lang.completion.DSLCompletion;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class MethodAccessorExpression
extends AbstractExpression
implements AssignableExpression {
    private AbstractExpression parentExpression;
    private String methodName;
    private List<AbstractExpression> arguments;
    private boolean argumentsContainObjectType;
    protected boolean unwrapBytesArray = false;
    private Method method;

    public MethodAccessorExpression(AbstractExpression parentExpression, String methodName, List<AbstractExpression> arguments) {
        super(Priority.PRIORITY1);
        this.parentExpression = parentExpression;
        this.methodName = methodName;
        this.arguments = arguments;
        this.setResultType(TypeFactory.createObjectType());
    }

    @Override
    public ValueAccessor evaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
        return new MethodAccessor(this.parentExpression.evaluate(context));
    }

    @Override
    protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
        for (int i = 0; i < this.arguments.size(); ++i) {
            this.arguments.set(i, this.arguments.get(i).compile(context));
            this.argumentsContainObjectType = this.arguments.get(i).getResultType() instanceof ObjectType;
        }
        this.validate(context);
        return this;
    }

    private void internalResolveMethodType(TriggerFunctionContext context, String parentClassName) throws ExpressionExecutionException {
        try {
            if (parentClassName == null) {
                throw new ExpressionExecutionException("Type for field '" + this.parentExpression.toString() + "' not defined.", this.parentExpression);
            }
            Class<?> parentClass = context.loadClass(parentClassName);
            Class[] argumentTypes = new Class[this.arguments.size()];
            for (int i = 0; i < this.arguments.size(); ++i) {
                argumentTypes[i] = TypeFactory.resolveClass(this.arguments.get(i).getResultType(), context);
            }
            this.method = ClassUtils.findBestDeclaredOrInheritedMethod(parentClass, this.methodName, argumentTypes, true);
            if (this.method == null) {
                List<Method> methods = ClassUtils.findSatisfiableMethods(parentClass, this.methodName, argumentTypes, true, false);
                if (methods == null || methods.size() != 1) {
                    for (int i = 0; i < this.arguments.size(); ++i) {
                        if (argumentTypes[i] == null || argumentTypes[i] != Byte[].class) continue;
                        argumentTypes[i] = byte[].class;
                        this.unwrapBytesArray = true;
                    }
                    methods = ClassUtils.findSatisfiableMethods(parentClass, this.methodName, argumentTypes, true, false);
                }
                Object arguments = "[";
                for (int i = 0; i < argumentTypes.length; ++i) {
                    if (i > 0) {
                        arguments = (String)arguments + ", ";
                    }
                    arguments = (String)arguments + argumentTypes[i].getName();
                }
                arguments = (String)arguments + "]";
                if (methods == null || methods.size() == 0) {
                    throw new ExpressionExecutionException("Method '" + this.methodName + "' with specified arguments " + (String)arguments + " not found in '" + this.parentExpression.toString() + "'.", this.parentExpression);
                }
                if (methods.size() > 1) {
                    Trace.logError(this, "More than one method '" + this.methodName + "' with specified arguments " + (String)arguments + " found in '" + this.parentExpression.toString() + "' Using last method.");
                }
                this.method = methods.get(methods.size() - 1);
            }
            this.setResultType(TypeFactory.resolveType(this.method.getReturnType(), (SemanticTypeLookupContext)context));
            if (this.parentExpression.getResultType() instanceof EventType) {
                this.setResultType(EventValueAccessorExpression.resolvePayloadType(context, (EventType)this.parentExpression.getResultType(), this.methodName, this.getResultType()));
            }
        }
        catch (ClassNotFoundException exception) {
            throw new ExpressionExecutionException("Failed to access method  '" + this.methodName + "' in object '" + this.parentExpression.toString() + "' of type '" + this.parentExpression.getResultType().getName() + "'. Cause: " + exception.getMessage() + ".", this.parentExpression, exception);
        }
    }

    @Override
    public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
        this.parentExpression.validate(context);
        Type<?> parentType = this.parentExpression.getResultType();
        if (!this.argumentsContainObjectType) {
            boolean resolveMethodsNow = false;
            if (parentType instanceof AbstractObjectType) {
                AbstractObjectType parentObjectType = (AbstractObjectType)parentType;
                if (parentObjectType.getType() != Types.OBJECT && (parentObjectType.getType() != Types.EVENT || parentObjectType.getJavaClassName() != null)) {
                    resolveMethodsNow = true;
                }
            } else if (parentType.getJavaClassName() != null) {
                resolveMethodsNow = true;
            }
            if (resolveMethodsNow) {
                this.internalResolveMethodType(context, parentType.getJavaClassName());
            }
        }
    }

    @Override
    public DSLCompletion complete(TriggerFunctionContext context) throws ExpressionExecutionException {
        this.parentExpression.validate(context);
        String parentClassName = this.parentExpression.getResultType().getJavaClassName();
        if (parentClassName == null) {
            if (this.parentExpression.getResultType() instanceof EventType) {
                try {
                    ((EventType)this.parentExpression.getResultType()).resolveEventType(context);
                }
                catch (Exception exception) {
                    throw new ExpressionExecutionException("Failed to resolve event type.", this, exception);
                }
            }
            parentClassName = this.parentExpression.getResultType().getJavaClassName();
        }
        if (parentClassName == null) {
            throw new ExpressionExecutionException("Failed to resolve event type.", this);
        }
        try {
            return new MethodCompleter(context.loadClass(parentClassName), context, false).complete(this.methodName);
        }
        catch (ClassNotFoundException exception) {
            throw new ExpressionExecutionException("Failed to load parent class.", this);
        }
    }

    @Override
    protected void onToString(StringBuilder builder) {
        this.parentExpression.toString(builder);
        builder.append(".").append(this.methodName).append("(");
        for (int i = 0; i < this.arguments.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            this.arguments.get(i).toString(builder);
        }
        builder.append(")");
    }

    class MethodAccessor
    extends AbstractTransactionalValueAccessor {
        MethodAccessor(ValueAccessor parentValueAccessor) {
            super(parentValueAccessor);
        }

        @Override
        public Type<?> getType() {
            return MethodAccessorExpression.this.getResultType();
        }

        @Override
        protected void resolveTypeInRuntime(TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
            Object parentValue = this.parentValueAccessor.getValue(context);
            if (parentValue == null) {
                return;
            }
            Type<?> parentType = this.parentValueAccessor.getType();
            if (parentType.getType() == Types.OBJECT || MethodAccessorExpression.this.argumentsContainObjectType || parentType.getType() == Types.EVENT || parentType.getType() == Types.MAP || parentType.getType() == Types.QUEUE || context.needToReload(MethodAccessorExpression.this.method)) {
                MethodAccessorExpression.this.internalResolveMethodType(context, parentValue.getClass().getName());
            }
        }

        @Override
        protected Object onGetValue(TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
            Object parentValue = this.parentValueAccessor.getValue(context);
            if (parentValue == null) {
                throw new ExpressionExecutionException("Failed to call method '" + MethodAccessorExpression.this.methodName + "' on null object '" + MethodAccessorExpression.this.parentExpression.toString() + "'.", MethodAccessorExpression.this.parentExpression);
            }
            Object[] argumentValues = new Object[MethodAccessorExpression.this.arguments.size()];
            for (int i = 0; i < MethodAccessorExpression.this.arguments.size(); ++i) {
                argumentValues[i] = MethodAccessorExpression.this.arguments.get((int)i).evaluateValueType((TriggerFunctionContext)context).value;
                if (!MethodAccessorExpression.this.unwrapBytesArray || argumentValues[i] == null || argumentValues[i].getClass() != Byte[].class) continue;
                argumentValues[i] = TypeFactory.unwrapBoxerValue(argumentValues[i]);
            }
            try {
                if (MethodAccessorExpression.this.method.getParameterTypes() != null && MethodAccessorExpression.this.method.getParameterTypes().length == 1 && MethodAccessorExpression.this.method.getParameterTypes()[0].isArray() && argumentValues.length > 1 && argumentValues[0] != null && !argumentValues[0].getClass().isArray()) {
                    Object[] newArgumentValues = (Object[])Array.newInstance(Object.class, 1);
                    newArgumentValues[0] = Array.newInstance(MethodAccessorExpression.this.method.getParameterTypes()[0].getComponentType(), argumentValues.length);
                    for (int i = 0; i < argumentValues.length; ++i) {
                        Array.set(newArgumentValues[0], i, argumentValues[i]);
                    }
                    argumentValues = newArgumentValues;
                }
                MethodAccessorExpression.this.method.setAccessible(true);
                Object result = MethodAccessorExpression.this.method.invoke(parentValue, argumentValues);
                if (context != null && result != null) {
                    if (this.getType().getType() == Types.OBJECT) {
                        ((ObjectType)this.getType()).setRealType(TypeFactory.resolveObjectType(result, context));
                    } else if (this.getType().getType() == Types.EVENT) {
                        MethodAccessorExpression.this.setResultType(TypeFactory.resolveType(result.getClass(), (SemanticTypeLookupContext)context));
                    }
                }
                super.valueChanged(context);
                return result;
            }
            catch (InvocationTargetException exception) {
                throw new ExpressionExecutionException("Method '" + MethodAccessorExpression.this.methodName + "' invocation exception: " + exception.getCause().getMessage(), MethodAccessorExpression.this.parentExpression, exception.getCause());
            }
            catch (IllegalAccessException exception) {
                throw new ExpressionExecutionException("Cannot access '" + MethodAccessorExpression.this.methodName + "' in object '" + MethodAccessorExpression.this.parentExpression.toString() + "' of type '" + MethodAccessorExpression.this.parentExpression.getResultType().getName() + "'.", MethodAccessorExpression.this.parentExpression, exception);
            }
        }

        @Override
        protected void onAssignValue(Object value, Type<?> valueType, TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
            throw new ValueConversionException("Assign value to method is forbidden.");
        }

        @Override
        public String toString() {
            return MethodAccessorExpression.this.toString();
        }
    }
}

