/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.fields;

import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.VariableAccessorExpression;
import com.streamscape.sef.evtrigger.function.expression.function.AbstractFunctionExpression;
import com.streamscape.sef.evtrigger.function.expression.function.FunctionsUnit;
import com.streamscape.sef.evtrigger.function.expression.function.SysFunctionsUnit;
import com.streamscape.sef.evtrigger.function.fields.FieldMethodAccessExpression;
import com.streamscape.sef.evtrigger.function.statement.Variable;
import com.streamscape.sef.evtrigger.function.types.DataspaceFunctionUnitType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.slex.lang.completion.DSLCompletion;
import java.io.Closeable;
import java.io.IOException;

public class FunctionUnitAccessorExpression
extends AbstractExpression {
    private AbstractExpression parentExpression;
    private FieldMethodAccessExpression fieldMethod;

    public FunctionUnitAccessorExpression(AbstractExpression parentExpression, FieldMethodAccessExpression fieldMethod) {
        super(Priority.PRIORITY1);
        this.parentExpression = parentExpression;
        this.fieldMethod = fieldMethod;
        this.setResultType(TypeFactory.createObjectType());
    }

    @Override
    protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
        return this;
    }

    @Override
    public ValueAccessor evaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
        FunctionsUnit functionsUnit = (FunctionsUnit)this.parentExpression.evaluateValueType((TriggerFunctionContext)context).value;
        AbstractFunctionExpression functionExpression = functionsUnit.lookupFunction(this.fieldMethod.getFieldName(), context);
        if (functionExpression == null) {
            throw new ExpressionExecutionException("Function '" + this.fieldMethod.toString() + "' not found.", this);
        }
        functionExpression.setArguments(this.fieldMethod.getArguments());
        functionExpression.setBeginEndPositions(this.getBeginPosition(), this.getEndPosition());
        functionExpression.setParentBlock(this.getParentBlock());
        functionExpression.setParentExpression(this.getParentExpression());
        functionExpression.compile(context);
        functionExpression.validate(context);
        return functionExpression.evaluate(context);
    }

    @Override
    public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
        this.parentExpression.validate(context);
        this.fieldMethod.validate(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DSLCompletion complete(TriggerFunctionContext context) throws ExpressionExecutionException {
        FunctionsUnit functionsUnit = null;
        if (this.parentExpression instanceof VariableAccessorExpression) {
            Variable variable = ((VariableAccessorExpression)this.parentExpression).getVariable();
            if (variable.isInitialized() && variable.getValue() instanceof FunctionsUnit) {
                functionsUnit = (FunctionsUnit)variable.getValue();
            }
            if (functionsUnit == null && variable.getType() instanceof DataspaceFunctionUnitType) {
                functionsUnit = this.parentExpression.getParentBlock().getStatementContext().getDefaultDataspaceFunctionsUnit();
            }
        } else {
            functionsUnit = SysFunctionsUnit.LookupFunction.createFunctionUnit(this.parentExpression, "SYS");
        }
        if (functionsUnit == null) {
            throw new ExpressionExecutionException("Function unit '" + this.parentExpression.getResultType().getType().toString() + "' doesn't support autocompletion.", this);
        }
        try {
            DSLCompletion dSLCompletion = functionsUnit.complete(context, this.fieldMethod.getFieldName());
            return dSLCompletion;
        }
        finally {
            if (functionsUnit instanceof Closeable) {
                try {
                    ((Closeable)((Object)functionsUnit)).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Type<?> narrowTypeFor(Type<?> type, TriggerFunctionContext context) {
        try {
            AbstractFunctionExpression function;
            FunctionsUnit functionsUnit = SysFunctionsUnit.LookupFunction.createFunctionUnit(this.parentExpression, "SYS");
            if (functionsUnit != null && (function = functionsUnit.lookupFunction(this.fieldMethod.getFieldName(), context)) != null) {
                return function.narrowTypeFor(type);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected void onToString(StringBuilder builder) {
        this.parentExpression.toString(builder);
        builder.append(".");
        this.fieldMethod.toString(builder);
    }
}

