/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.fields;

import com.streamscape.ds.stable.rplmethod.RPLMethodHidden;
import com.streamscape.ds.types.CloseableWrapper;
import com.streamscape.ds.types.DataspaceTypeWrapper;
import com.streamscape.ds.types.ServiceTypeWrapper;
import com.streamscape.lib.selector.SelectorExpression;
import com.streamscape.lib.selector.VariableSelectorExpression;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.enums.PropertyType;
import com.streamscape.sdo.security.AccessControl;
import com.streamscape.sef.dii.AccessibleObjectProxy;
import com.streamscape.sef.dispatcher.AbstractAccessibleObjectProxy;
import com.streamscape.sef.dispatcher.AccessibleObjectComponentSimple;
import com.streamscape.sef.evtrigger.function.fields.FieldAccessorByMethodExpression;
import com.streamscape.sef.scheduler.Execution;
import com.streamscape.sef.scheduler.ExecutionListener;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.SchedulerCompletionEvent;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.scheduler.TemplateType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class FieldsMethodsAllowedForCompletion {
    private static List<MethodInfo> excludedMethods = new ArrayList<MethodInfo>();
    private static List<FieldInfo> excludedFields;

    private static void excludeMethod(Class<?> clazz, String name, Class<?> ... args) {
        excludedMethods.add(new MethodInfo(clazz, name, true, args));
    }

    private static void excludeField(Class<?> clazz, String name) {
        excludedFields.add(new FieldInfo(clazz, name));
    }

    public static boolean isMethodAllowed(Class<?> clazz, Method method, boolean onlyStaticMethods) {
        return Modifier.isPublic(method.getModifiers()) && onlyStaticMethods == Modifier.isStatic(method.getModifiers()) && !excludedMethods.contains(new MethodInfo(method.getDeclaringClass(), method.getName(), false, method.getParameterTypes())) && !excludedMethods.contains(new MethodInfo(clazz, method.getName(), false, method.getParameterTypes())) && !FieldsMethodsAllowedForCompletion.isRplMethodHidden(method);
    }

    private static boolean isRplMethodHidden(Method method) {
        return method.getAnnotation(RPLMethodHidden.class) != null;
    }

    private static boolean isRplFieldHidden(Field field) {
        return field.getAnnotation(RPLMethodHidden.class) != null;
    }

    public static boolean isFieldAllowed(Field field) {
        Method method2;
        if (Modifier.isStatic(field.getModifiers()) || excludedFields.contains(new FieldInfo(field.getDeclaringClass(), field.getName()))) {
            return false;
        }
        if (FieldsMethodsAllowedForCompletion.isRplFieldHidden(field)) {
            return false;
        }
        if (Modifier.isPublic(field.getModifiers())) {
            return true;
        }
        boolean existsGetterOrSetter = false;
        if (!existsGetterOrSetter) {
            try {
                method2 = field.getDeclaringClass().getDeclaredMethod(FieldAccessorByMethodExpression.getGetterName(field.getName()), new Class[0]);
                existsGetterOrSetter = method2 != null && Modifier.isPublic(method2.getModifiers());
            }
            catch (NoSuchMethodException method2) {
                // empty catch block
            }
        }
        if (!existsGetterOrSetter) {
            try {
                method2 = field.getDeclaringClass().getDeclaredMethod(FieldAccessorByMethodExpression.getSetterName(field.getName()), field.getType());
                existsGetterOrSetter = method2 != null && Modifier.isPublic(method2.getModifiers());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return existsGetterOrSetter;
    }

    static {
        FieldsMethodsAllowedForCompletion.excludeMethod(Object.class, "clone", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(Object.class, "wait", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(Object.class, "wait", Long.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(Object.class, "wait", Long.TYPE, Integer.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(Object.class, "notify", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(Object.class, "notifyAll", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(Object.class, "hashCode", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(Object.class, "getClass", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(Object.class, "equals", Object.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Object.class, "intern", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(CloneableDataObject.class, "getSerialVersionUID", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(CloseableWrapper.class, "close", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(CloseableWrapper.class, "toString", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(DataspaceTypeWrapper.class, "getCurrentDataspace", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(AbstractAccessibleObjectProxy.class, "getId", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(AbstractAccessibleObjectProxy.class, "setId", Long.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(AbstractAccessibleObjectProxy.class, "setAccessor", AccessibleObjectComponentSimple.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(AbstractAccessibleObjectProxy.class, "setAccessor", Object.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(AccessibleObjectProxy.class, "setAccessor", AccessibleObjectComponentSimple.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(AccessibleObjectProxy.class, "setAccessor", Object.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Metaset.class, "getValue", VariableSelectorExpression.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Metaset.class, "getPredefinedProperties", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(Metaset.class, "getDynamicProperties", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(Metaset.class, "getValues", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getValue", VariableSelectorExpression.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Execution.class, "getValue", VariableSelectorExpression.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Execution.class, "matchesCondition", SelectorExpression.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "addAnnotation", String.class, String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "addLocator", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "addLocatorsAll", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "addLocatorsAllFrom", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "addTag", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "addTagsAll", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "addTagsAllFrom", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "addTagsAndLocatorsAll", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "addTagsAndLocatorsAllFrom", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "canConvertEventProperty", String.class, PropertyType.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "clearData", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "clearEventProperties", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getAnnotation", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getAnnotatedProperties", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getCorrelationId", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getCorrelationIdAsBytes", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getDurable", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getEventBigDecimalProperty", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getEventBooleanProperty", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getEventByteProperty", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getEventDoubleProperty", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getEventExpiration", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getEventFloatProperty", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getEventGroupId", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getEventIntProperty", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getEventKey", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getEventLongProperty", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getEventObjectProperty", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getEventPropertyType", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getEventShortProperty", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getForwardTo", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getPermissions", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getReadAccess", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getReplyTo", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getSecurityAssertionToken", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getSecurityAssertionTokenAsBytes", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getTransmitAccess", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "getWriteAccess", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "hasAnnotatedProperties", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "isProtected", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "protect", String.class, byte[].class, AccessControl.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "removeAnnotation", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "removeEventProperty", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "resetReplyTo", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "set", String.class, Object.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setBigDecimal", String.class, BigDecimal.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setBoolean", String.class, Boolean.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setByte", String.class, Byte.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setBytes", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setBytes", String.class, byte[].class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setChar", String.class, Character.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setCorrelationId", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setCorrelationIdAsBytes", byte[].class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setDate", String.class, Date.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setDouble", String.class, Double.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setDurable", Boolean.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setEventBigDecimalProperty", String.class, Integer.TYPE, Integer.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setEventBigDecimalProperty", String.class, BigDecimal.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setEventBooleanProperty", String.class, Boolean.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setEventByteProperty", String.class, Byte.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setEventDoubleProperty", String.class, Double.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setEventExpiration", Long.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setEventFloatProperty", String.class, Float.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setEventGroupId", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setEventIntProperty", String.class, Integer.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setEventKey", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setEventLongProperty", String.class, Long.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setEventObjectProperty", String.class, Object.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setEventShortProperty", String.class, Short.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setEventStringProperty", String.class, String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setFailed", Boolean.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setFinal", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setFloat", String.class, Float.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setForwardTo", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setInt", String.class, Integer.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setLong", String.class, Long.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setMap", Map.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setObject", String.class, Object.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setReplyTo", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setSecurityAssertionToken", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setSecurityAssertionTokenAsBytes", byte[].class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setShort", String.class, Short.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "setString", String.class, String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "toString", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(SchedulerCompletionEvent.class, "unprotect", String.class, byte[].class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "addTemplate", TemplateType.class, String.class, String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "createMetaset", String.class, String.class, Map.class, Boolean.TYPE);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "createTrigger", String.class, String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "createTrigger", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "dropTrigger", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "executeTask", String.class, String.class, Metaset.class, ExecutionListener.class, Date.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "executeTaskList", String.class, Metaset.class, ExecutionListener.class, Date.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "existsTemplate", TemplateType.class, String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "existsTrigger", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "getExecution", String.class, UUID.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "getLastExecution", UUID.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "getMetaset", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "getParameter", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "getTemplate", TemplateType.class, String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "getTrigger", String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "getTriggers", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "listParameters", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "listTemplates", TemplateType.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "listTriggers", new Class[0]);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "removeTemplate", TemplateType.class, String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "setTemplate", TemplateType.class, String.class, String.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "updateMetaset", String.class, String.class, Map.class, Boolean.class);
        FieldsMethodsAllowedForCompletion.excludeMethod(Scheduler.class, "toString", new Class[0]);
        excludedFields = new ArrayList<FieldInfo>();
        FieldsMethodsAllowedForCompletion.excludeField(ServiceTypeWrapper.class, "accessor");
        FieldsMethodsAllowedForCompletion.excludeField(TaskList.class, "eventScope");
        FieldsMethodsAllowedForCompletion.excludeField(TaskList.class, "exceptionTask");
        FieldsMethodsAllowedForCompletion.excludeField(TaskList.class, "exceptionTasks");
        FieldsMethodsAllowedForCompletion.excludeField(TaskList.class, "execution");
        FieldsMethodsAllowedForCompletion.excludeField(TaskList.class, "executionMetaset");
        FieldsMethodsAllowedForCompletion.excludeField(TaskList.class, "job");
        FieldsMethodsAllowedForCompletion.excludeField(TaskList.class, "retentionInterval");
        FieldsMethodsAllowedForCompletion.excludeField(TaskList.class, "retentionIntervalUnit");
        FieldsMethodsAllowedForCompletion.excludeField(TaskList.class, "state");
        FieldsMethodsAllowedForCompletion.excludeField(TaskList.class, "taskDelay");
        FieldsMethodsAllowedForCompletion.excludeField(TaskList.class, "taskListWindow");
        FieldsMethodsAllowedForCompletion.excludeField(TaskList.class, "taskListWindowUnit");
        FieldsMethodsAllowedForCompletion.excludeField(TaskList.class, "tasks");
    }

    static class MethodInfo {
        Class<?> clazz;
        String name;
        private boolean parent;
        Class<?>[] args;

        MethodInfo(Class<?> clazz, String name, boolean parent, Class<?> ... args) {
            this.clazz = clazz;
            this.name = name;
            this.parent = parent;
            this.args = args;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MethodInfo)) {
                return false;
            }
            MethodInfo method = (MethodInfo)o;
            if (this.name.equals(method.name) && (this.parent && this.clazz.isAssignableFrom(method.clazz) || method.parent && method.clazz.isAssignableFrom(this.clazz))) {
                if (this.args == method.args) {
                    return true;
                }
                if (this.args == null) {
                    return method.args.length == 0;
                }
                if (method.args == null) {
                    return this.args.length == 0;
                }
                if (this.args.length != method.args.length) {
                    return false;
                }
                for (int i = 0; i < this.args.length; ++i) {
                    if (this.args[i].equals(method.args[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    static class FieldInfo {
        Class<?> clazz;
        String name;

        FieldInfo(Class<?> clazz, String name) {
            this.clazz = clazz;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FieldInfo)) {
                return false;
            }
            FieldInfo field = (FieldInfo)o;
            return this.name.equals(field.name) && (this.clazz.isAssignableFrom(field.clazz) || field.clazz.isAssignableFrom(this.clazz));
        }
    }
}

