/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.fields;

import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.AssignableExpression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import java.util.List;

public class FieldMethodAccessExpression
extends AbstractExpression
implements AssignableExpression {
    private String fieldName;
    private List<AbstractExpression> arguments;

    public FieldMethodAccessExpression(String fieldName) {
        super(Priority.PRIORITY14);
        this.fieldName = fieldName;
    }

    public void setArguments(List<AbstractExpression> arguments) {
        this.arguments = arguments;
    }

    @Override
    public ValueAccessor evaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
        throw new ExpressionExecutionException("evaluate not allowed for FieldFunctionAccessExpression", this);
    }

    @Override
    public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.size(); ++i) {
                this.arguments.get(i).validate(context);
            }
        }
    }

    @Override
    protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.size(); ++i) {
                this.arguments.set(i, this.arguments.get(i).compile(context));
            }
        }
        return this;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public List<AbstractExpression> getArguments() {
        return this.arguments;
    }

    public boolean isMethod() {
        return this.arguments != null;
    }

    @Override
    protected void onToString(StringBuilder builder) {
        builder.append(this.fieldName);
        if (this.arguments != null) {
            builder.append("(");
            for (int i = 0; i < this.arguments.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                this.arguments.get(i).toString(builder);
            }
            builder.append(")");
        }
    }
}

