/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.fields;

import com.streamscape.ds.parser.completion.FieldCompleter;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.fields.AbstractFieldAccessorExpression;
import com.streamscape.sef.evtrigger.function.types.EventType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import com.streamscape.slex.lang.completion.DSLCompletion;

class FieldAccessorByNameExpression
extends AbstractFieldAccessorExpression {
    public FieldAccessorByNameExpression(AbstractExpression parentExpression, String fieldName) {
        super(parentExpression, fieldName);
    }

    @Override
    public ValueAccessor evaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
        return new FieldAccessorByName(this.parentExpression.evaluate(context));
    }

    @Override
    public DSLCompletion complete(TriggerFunctionContext context) throws ExpressionExecutionException {
        this.parentExpression.validate(context);
        String parentClassName = this.parentExpression.getResultType().getJavaClassName();
        if (parentClassName == null) {
            if (this.parentExpression.getResultType() instanceof EventType) {
                try {
                    ((EventType)this.parentExpression.getResultType()).resolveEventType(context);
                }
                catch (Exception exception) {
                    throw new ExpressionExecutionException("Failed to resolve event type.", this, exception);
                }
            }
            parentClassName = this.parentExpression.getResultType().getJavaClassName();
        }
        if (parentClassName == null) {
            throw new ExpressionExecutionException("Failed to resolve event type.", this);
        }
        try {
            return new FieldCompleter(context.loadClass(parentClassName), context).complete(this.fieldName);
        }
        catch (ClassNotFoundException exception) {
            throw new ExpressionExecutionException("Failed to load parent class.", this);
        }
    }

    @Override
    protected void onToString(StringBuilder builder) {
        this.parentExpression.toString(builder);
        builder.append("." + this.fieldName);
    }

    class FieldAccessorByName
    extends AbstractFieldAccessorExpression.AbstractFieldAccessor {
        FieldAccessorByName(ValueAccessor parentValueAccessor) {
            super(parentValueAccessor);
        }

        @Override
        public Object onGetValue(TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
            Object parentValue = this.parentValueAccessor.getValue(context);
            if (parentValue == null) {
                throw new ExpressionExecutionException("Failed to access field '" + FieldAccessorByNameExpression.this.fieldName + "' in null object '" + this.parentValueAccessor.toString() + "'.", FieldAccessorByNameExpression.this.parentExpression);
            }
            if (FieldAccessorByNameExpression.this.field == null) {
                throw new ExpressionExecutionException("Field '" + FieldAccessorByNameExpression.this.fieldName + "' is not resolved, parent object: '" + this.parentValueAccessor.toString() + "'.", FieldAccessorByNameExpression.this.parentExpression);
            }
            try {
                return FieldAccessorByNameExpression.this.field.get(parentValue);
            }
            catch (Exception exception) {
                throw new ExpressionExecutionException("Failed to access field '" + FieldAccessorByNameExpression.this.fieldName + "' in object '" + this.parentValueAccessor.toString() + "' of type '" + parentValue.getClass().getName() + "'. Cause: " + exception.getMessage(), FieldAccessorByNameExpression.this.parentExpression, exception);
            }
        }

        @Override
        protected void onAssignValue(Object value, Type<?> valueType, TriggerFunctionContext context) throws ValueConversionException, ExpressionExecutionException {
            Object parentValue = this.parentValueAccessor.getValue(context);
            if (parentValue == null) {
                throw new ExpressionExecutionException("Failed to set field '" + FieldAccessorByNameExpression.this.fieldName + "' in null object '" + this.parentValueAccessor.toString() + "'.", FieldAccessorByNameExpression.this.parentExpression);
            }
            if (FieldAccessorByNameExpression.this.field == null) {
                throw new ExpressionExecutionException("Field '" + FieldAccessorByNameExpression.this.fieldName + "' is not resolved, parent object: '" + this.parentValueAccessor.toString() + "'.", FieldAccessorByNameExpression.this.parentExpression);
            }
            try {
                FieldAccessorByNameExpression.this.field.set(parentValue, TypeFactory.wrapUnwrapValue(FieldAccessorByNameExpression.this.field.getType(), this.getType().convertValue(value, valueType)));
            }
            catch (ValueConversionException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new ExpressionExecutionException(exception.getMessage(), FieldAccessorByNameExpression.this.parentExpression);
            }
        }

        @Override
        public String toString() {
            return FieldAccessorByNameExpression.this.toString();
        }
    }
}

