/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.fields;

import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.fields.AbstractFieldAccessorExpression;
import com.streamscape.sef.evtrigger.function.fields.ValueAccessorByMethodHelper;
import com.streamscape.sef.evtrigger.function.types.EventType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;

public class FieldAccessorByMethodExpression
extends AbstractFieldAccessorExpression {
    private String setMethodName;
    private String getMethodName;
    private ValueAccessorByMethodHelper valueAccessorByMethodHelper;

    public FieldAccessorByMethodExpression(AbstractExpression parentExpression, String fieldName) {
        super(parentExpression, fieldName);
        this.setMethodName = FieldAccessorByMethodExpression.getSetterName(fieldName);
        this.getMethodName = FieldAccessorByMethodExpression.getGetterName(fieldName);
    }

    @Override
    public ValueAccessor evaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
        return new FieldAccessorByMethod(this.parentExpression.evaluate(context));
    }

    @Override
    protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
        super.onCompile(context);
        Type<?> parentType = this.parentExpression.getResultType();
        if (parentType.getType() != Types.OBJECT && (parentType.getType() != Types.EVENT || ((EventType)parentType).getSemanticTypeClassName() != null)) {
            this.internalResolveFieldType(context);
        }
        return this;
    }

    private void internalResolveFieldType(TriggerFunctionContext context) throws ExpressionExecutionException {
        if (this.parentClass == null || this.fieldName == null) {
            throw new ExpressionExecutionException("Failed to access field  '" + this.fieldName + "' in null object '" + this.parentExpression.toString() + "'.", this.parentExpression);
        }
        this.valueAccessorByMethodHelper = new ValueAccessorByMethodHelper(this.parentClass, this.fieldName, this.field.getType(), this.getMethodName, this.setMethodName);
        try {
            this.valueAccessorByMethodHelper.resolveMethods(context);
        }
        catch (TypeConversionException exception) {
            throw new ExpressionExecutionException(exception.getMessage(), this.parentExpression, exception);
        }
    }

    @Override
    protected void onToString(StringBuilder builder) {
        this.parentExpression.toString(builder);
        builder.append("." + this.fieldName);
    }

    public static String getGetterName(String fieldName) {
        return "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }

    public static String getSetterName(String fieldName) {
        return "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
    }

    class FieldAccessorByMethod
    extends AbstractFieldAccessorExpression.AbstractFieldAccessor {
        FieldAccessorByMethod(ValueAccessor parentValueAccessor) {
            super(parentValueAccessor);
        }

        @Override
        protected void resolveTypeInRuntime(TriggerFunctionContext context) throws ValueConversionException, ExpressionExecutionException {
            super.resolveTypeInRuntime(context);
            if (FieldAccessorByMethodExpression.this.valueAccessorByMethodHelper == null || FieldAccessorByMethodExpression.this.valueAccessorByMethodHelper.needToReload(context)) {
                FieldAccessorByMethodExpression.this.internalResolveFieldType(context);
            }
        }

        @Override
        public Object onGetValue(TriggerFunctionContext context) throws ValueConversionException, ExpressionExecutionException {
            if (FieldAccessorByMethodExpression.this.valueAccessorByMethodHelper == null) {
                throw new ExpressionExecutionException("Method for field '" + FieldAccessorByMethodExpression.this.fieldName + "' is not resolved, parent object: '" + this.parentValueAccessor.toString() + "'.", FieldAccessorByMethodExpression.this.parentExpression);
            }
            Object result = FieldAccessorByMethodExpression.this.valueAccessorByMethodHelper.onGetValue(this.parentValueAccessor, context);
            if (result != null) {
                FieldAccessorByMethodExpression.this.setResultType(TypeFactory.resolveObjectType(result, context));
            }
            return result;
        }

        @Override
        protected void onAssignValue(Object value, Type<?> valueType, TriggerFunctionContext context) throws ValueConversionException, ExpressionExecutionException {
            if (FieldAccessorByMethodExpression.this.valueAccessorByMethodHelper == null) {
                throw new ExpressionExecutionException("Method for field '" + FieldAccessorByMethodExpression.this.fieldName + "' is not resolved, parent object: '" + this.parentValueAccessor.toString() + "'.", FieldAccessorByMethodExpression.this.parentExpression);
            }
            FieldAccessorByMethodExpression.this.valueAccessorByMethodHelper.onAssign(this.parentValueAccessor, value, valueType, context);
        }

        @Override
        public String toString() {
            return FieldAccessorByMethodExpression.this.toString();
        }
    }
}

