/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.fields;

import com.streamscape.ds.parser.completion.EnumValueCompleter;
import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.types.EnumType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import com.streamscape.slex.lang.completion.DSLCompletion;

public class EnumValueAccessorExpression
extends AbstractExpression {
    private String enumValueName;
    private Enum<?> enumValue;

    public EnumValueAccessorExpression(Type<?> enumType, String enumValueName) {
        super(Priority.PRIORITY1);
        this.enumValueName = enumValueName;
        this.setResultType(enumType);
    }

    @Override
    public ValueAccessor evaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
        return new EnumValueAccessor();
    }

    @Override
    protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
        if (!(this.getResultType() instanceof EnumType)) {
            throw new ExpressionExecutionException("EnumType only allowed in EnumValueAccessorExpression, but passed '" + this.getResultType().getName() + "'.", this);
        }
        this.internalInitializeEventValue(context);
        return this;
    }

    @Override
    public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
    }

    private void internalInitializeEventValue(TriggerFunctionContext context) throws ExpressionExecutionException {
        EnumType enumType = (EnumType)this.getResultType();
        try {
            Class<?> enumClass = context.loadClass(enumType.getSemanticTypeClassName());
            if (!enumClass.isEnum()) {
                throw new ExpressionExecutionException("'" + enumType.getSemanticTypeName() + "' is not Enum type.", this);
            }
            try {
                this.enumValue = Enum.valueOf(enumClass, this.enumValueName);
            }
            catch (Exception exception) {
                throw new ExpressionExecutionException("Value '" + this.enumValueName + "' not found in enum '" + enumType.getSemanticTypeName() + "'.", this, exception);
            }
        }
        catch (ClassNotFoundException exception) {
            throw new ExpressionExecutionException("Failed to load enum class '" + enumType.getSemanticTypeClassName() + "'.", this, exception);
        }
    }

    @Override
    public DSLCompletion complete(TriggerFunctionContext context) throws ExpressionExecutionException {
        EnumType enumType = (EnumType)this.getResultType();
        try {
            Class<?> enumClass = context.loadClass(enumType.getSemanticTypeClassName());
            if (!enumClass.isEnum()) {
                throw new ExpressionExecutionException("'" + enumType.getSemanticTypeName() + "' is not Enum type.", this);
            }
            return new EnumValueCompleter(enumClass).complete(this.enumValueName);
        }
        catch (ClassNotFoundException exception) {
            throw new ExpressionExecutionException("Failed to load enum class '" + enumType.getSemanticTypeClassName() + "'.", this, exception);
        }
    }

    @Override
    protected void onToString(StringBuilder builder) {
        builder.append(this.getResultType().getName() + "." + this.enumValueName);
    }

    class EnumValueAccessor
    implements ValueAccessor {
        EnumValueAccessor() {
        }

        @Override
        public Type<?> getType() {
            return EnumValueAccessorExpression.this.getResultType();
        }

        @Override
        public Object getValue(TriggerFunctionContext context) throws ValueConversionException {
            if (EnumValueAccessorExpression.this.enumValue == null || context.needToReload(EnumValueAccessorExpression.this.enumValue.getDeclaringClass())) {
                try {
                    EnumValueAccessorExpression.this.internalInitializeEventValue(context);
                }
                catch (ExpressionExecutionException exception) {
                    throw new ValueConversionException(exception.getMessage());
                }
            }
            return EnumValueAccessorExpression.this.enumValue;
        }

        @Override
        public void assignValue(Object value, Type<?> valueType, TriggerFunctionContext context) throws ValueConversionException {
            throw new ValueConversionException("Assign operation not allowed for enum values.");
        }

        @Override
        public String toString() {
            return EnumValueAccessorExpression.this.toString();
        }
    }
}

