/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.fields;

import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.Types;

public class EnumExpression
extends AbstractExpression {
    private String enumTypeName;

    public EnumExpression(String enumTypeName) {
        super(Priority.PRIORITY14);
        this.enumTypeName = enumTypeName;
        this.setResultType(TypeFactory.createObjectType());
    }

    @Override
    public ValueAccessor evaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
        throw new ExpressionExecutionException("evaluate method is not allowed for EnumExpression", this);
    }

    @Override
    public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
        throw new ExpressionExecutionException("validate method is not allowed for EnumExpression", this);
    }

    @Override
    protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
        try {
            this.setResultType(TypeFactory.createSemanticTypeType(this.enumTypeName, context));
            if (this.getResultType() == null) {
                throw new ExpressionExecutionException("Failed to load enum of type '" + this.enumTypeName + "'. Semantic type doesn't exists.", this);
            }
            if (this.getResultType().getType() != Types.ENUM) {
                throw new ExpressionExecutionException("'" + this.enumTypeName + "' is not enum.", this);
            }
        }
        catch (ClassNotFoundException exception) {
            throw new ExpressionExecutionException("Failed to load object of type '" + this.enumTypeName + "'. Cause: Type is not loaded.", this, exception);
        }
        return this;
    }

    @Override
    protected void onToString(StringBuilder builder) {
        builder.append(this.enumTypeName);
    }
}

