/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.fields;

import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.arrays.ArrayLengthAccessorExpression;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.AssignableExpression;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionArgumentsException;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.operation.AbstractBinaryOperationExpression;
import com.streamscape.sef.evtrigger.function.fields.EnumExpression;
import com.streamscape.sef.evtrigger.function.fields.EnumValueAccessorExpression;
import com.streamscape.sef.evtrigger.function.fields.FieldAccessorByNameExpression;
import com.streamscape.sef.evtrigger.function.fields.FieldMethodAccessExpression;
import com.streamscape.sef.evtrigger.function.fields.FunctionUnitAccessorExpression;
import com.streamscape.sef.evtrigger.function.fields.MethodAccessorExpression;
import com.streamscape.sef.evtrigger.function.fields.event.EventValueAccessorExpression;
import com.streamscape.sef.evtrigger.function.types.EventType;
import com.streamscape.sef.evtrigger.function.types.FunctionUnitType;
import com.streamscape.sef.evtrigger.function.types.ObjectType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.tools.console.autocompletion.CompoundCompleter;

public class DotOperation
extends AbstractBinaryOperationExpression
implements AssignableExpression {
    public DotOperation() {
        super(".", Priority.PRIORITY14, false);
    }

    @Override
    protected void onValidateArguments() throws ExpressionArgumentsException {
        if (!(this.arguments[1] instanceof FieldMethodAccessExpression)) {
            throw new ExpressionArgumentsException("Dot operations expects field or function name as second argument.", this.arguments[1]);
        }
    }

    @Override
    protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
        AbstractExpression result;
        this.arguments[0] = this.arguments[0].compile(context);
        this.arguments[1] = this.arguments[1].compile(context);
        FieldMethodAccessExpression fieldMethod = (FieldMethodAccessExpression)this.arguments[1];
        Type<?> parentType = this.arguments[0].getResultType();
        if (parentType == TypeFactory.VOIDTYPE) {
            throw new ExpressionExecutionException("Cannot access void type '" + this.arguments[0].toString() + "'.", this.arguments[0]);
        }
        if ((parentType.getType() == Types.ARRAY || parentType.getType() == Types.OBJECT && ((ObjectType)parentType).getRealType() != null && ((ObjectType)parentType).getRealType().getType() == Types.ARRAY) && !fieldMethod.isMethod() && fieldMethod.getFieldName().equals("length")) {
            result = new ArrayLengthAccessorExpression(this.arguments[0]);
        } else if (parentType.getType() == Types.ENUM && this.arguments[0] instanceof EnumExpression) {
            if (fieldMethod.isMethod()) {
                throw new ExpressionExecutionException("Method call is not allowed for enums.", this);
            }
            result = new EnumValueAccessorExpression(parentType, fieldMethod.getFieldName());
        } else {
            result = parentType instanceof FunctionUnitType ? new FunctionUnitAccessorExpression(this.arguments[0], fieldMethod) : (!fieldMethod.isMethod() ? (parentType instanceof EventType ? new EventValueAccessorExpression(this.arguments[0], fieldMethod.getFieldName()) : new FieldAccessorByNameExpression(this.arguments[0], fieldMethod.getFieldName())) : new MethodAccessorExpression(this.arguments[0], fieldMethod.getFieldName(), fieldMethod.getArguments()));
        }
        return result;
    }

    @Override
    public DSLCompletion complete(TriggerFunctionContext context) throws ExpressionExecutionException {
        this.arguments[0] = this.arguments[0].compile(context);
        FieldMethodAccessExpression fieldMethod = (FieldMethodAccessExpression)this.arguments[1];
        Type<?> parentType = this.arguments[0].getResultType();
        if (parentType == TypeFactory.VOIDTYPE) {
            throw new ExpressionExecutionException("Cannot access void type '" + this.arguments[0].toString() + "'.", this.arguments[0]);
        }
        DSLCompletion result = null;
        if (parentType.getType() == Types.ENUM && this.arguments[0] instanceof EnumExpression) {
            result = new EnumValueAccessorExpression(parentType, fieldMethod.getFieldName()).complete(context);
        } else if (parentType instanceof FunctionUnitType) {
            result = new FunctionUnitAccessorExpression(this.arguments[0], fieldMethod).complete(context);
        } else {
            if (parentType instanceof EventType) {
                result = new EventValueAccessorExpression(this.arguments[0], fieldMethod.getFieldName(), true).complete(context);
            }
            result = CompoundCompleter.mergeCompletions(fieldMethod.getFieldName(), new FieldAccessorByNameExpression(this.arguments[0], fieldMethod.getFieldName()).complete(context), result);
            result = CompoundCompleter.mergeCompletions(fieldMethod.getFieldName(), new MethodAccessorExpression(this.arguments[0], fieldMethod.getFieldName(), fieldMethod.getArguments()).complete(context), result);
        }
        return result;
    }

    @Override
    public ValueAccessor evaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
        throw this.methodNotAllowedException("evaluate");
    }

    @Override
    public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
        throw this.methodNotAllowedException("validate");
    }

    @Override
    protected Object onEvaluateResult(Expression.ValueTypeResult result1, Expression.ValueTypeResult result2, TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
        return null;
    }

    @Override
    protected void onValidate(Type<?> type1, Type<?> type2) throws ExpressionExecutionException, TypeConversionException {
    }

    protected RuntimeException methodNotAllowedException(String methodName) {
        return new RuntimeException("Method '" + methodName + "' is not allowed in DotOperation.");
    }
}

