/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.fields;

import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.AbstractTransactionalValueAccessor;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.AssignableExpression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.types.AbstractObjectType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.Types;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;
import java.lang.reflect.Field;

abstract class AbstractFieldAccessorExpression
extends AbstractExpression
implements AssignableExpression {
    protected AbstractExpression parentExpression;
    protected String fieldName;
    protected Field field;
    protected Class<?> parentClass;

    public AbstractFieldAccessorExpression(AbstractExpression parentExpression, String fieldName) {
        super(Priority.PRIORITY1);
        this.parentExpression = parentExpression;
        this.fieldName = fieldName;
        this.setResultType(TypeFactory.createObjectType());
    }

    @Override
    protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
        Type<?> parentType = this.parentExpression.getResultType();
        if (!(parentType instanceof AbstractObjectType)) {
            throw new ExpressionExecutionException("Failed to access field '" + this.fieldName + "' for object of type '" + parentType.getName() + "'.", this.parentExpression);
        }
        AbstractObjectType parentObjectType = (AbstractObjectType)parentType;
        if (parentObjectType.getType() != Types.OBJECT && (parentObjectType.getType() != Types.EVENT || parentObjectType.getSemanticTypeClassName() != null)) {
            this.internalResolveFieldType(context, parentObjectType.getSemanticTypeClassName());
        }
        return this;
    }

    private void internalResolveFieldType(TriggerFunctionContext context, String parentClassName) throws ExpressionExecutionException {
        try {
            if (parentClassName == null) {
                throw new TypeConversionException("Type for field '" + this.parentExpression.toString() + "' not defined.");
            }
            this.parentClass = context.loadClass(parentClassName);
            this.field = ClassUtils.getClassField(this.parentClass, this.fieldName);
            this.field.setAccessible(true);
            this.setResultType(TypeFactory.resolveFieldType(this.field, context));
        }
        catch (UtilitiesException exception) {
            throw new ExpressionExecutionException("Object '" + this.parentExpression.toString() + "' of type '" + this.parentExpression.getResultType().getName() + "' doesn't contain field with name '" + this.fieldName + "'.", this.parentExpression, exception);
        }
        catch (Exception exception) {
            throw new ExpressionExecutionException("Failed to access field  '" + this.fieldName + "' in object '" + this.parentExpression.toString() + "' of type '" + this.parentExpression.getResultType().getName() + "'. Cause: " + exception.getMessage() + ".", this.parentExpression, exception);
        }
    }

    @Override
    public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
        this.parentExpression.validate(context);
    }

    abstract class AbstractFieldAccessor
    extends AbstractTransactionalValueAccessor {
        AbstractFieldAccessor(ValueAccessor parentValueAccessor) {
            super(parentValueAccessor);
        }

        @Override
        public Type<?> getType() {
            return AbstractFieldAccessorExpression.this.getResultType();
        }

        @Override
        protected void resolveTypeInRuntime(TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
            if ((context.needToReload(AbstractFieldAccessorExpression.this.parentClass) || context.needToReload(AbstractFieldAccessorExpression.this.field)) && this.parentValueAccessor.getValue(context) != null) {
                AbstractFieldAccessorExpression.this.internalResolveFieldType(context, this.parentValueAccessor.getValue(context).getClass().getName());
            }
        }
    }
}

