/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.evtrigger.function.expression.operation;

import com.streamscape.sef.evtrigger.function.Priority;
import com.streamscape.sef.evtrigger.function.TriggerFunctionContext;
import com.streamscape.sef.evtrigger.function.accessor.AbstractTransactionalValueAccessor;
import com.streamscape.sef.evtrigger.function.accessor.ValueAccessor;
import com.streamscape.sef.evtrigger.function.expression.AbstractExpression;
import com.streamscape.sef.evtrigger.function.expression.AssignableExpression;
import com.streamscape.sef.evtrigger.function.expression.ConstantExpression;
import com.streamscape.sef.evtrigger.function.expression.Expression;
import com.streamscape.sef.evtrigger.function.expression.ExpressionExecutionException;
import com.streamscape.sef.evtrigger.function.expression.operation.AbstractUnaryOperationExpression;
import com.streamscape.sef.evtrigger.function.types.ArrayType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeConversionException;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.evtrigger.function.types.ValueConversionException;

public class CastOperation
extends AbstractUnaryOperationExpression
implements AssignableExpression {
    private String semanctiTypeName;
    private boolean isArray = false;

    public CastOperation(Type<?> castToType) {
        super("(" + castToType.getName() + ")", Priority.PRIORITY13, false);
        this.setResultType(castToType);
    }

    public CastOperation(String semanctiTypeName, boolean isArray) {
        super("(" + semanctiTypeName + ")", Priority.PRIORITY13, false);
        this.semanctiTypeName = semanctiTypeName;
        this.isArray = isArray;
    }

    @Override
    public ValueAccessor evaluate(TriggerFunctionContext context) throws ExpressionExecutionException {
        return new CastValueAccessor(this.arguments[0].evaluate(context));
    }

    @Override
    protected Object onEvaluateResult(Expression.ValueTypeResult result, TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
        throw new RuntimeException("CastOperation.onEvaluateResult method whould be never called.");
    }

    @Override
    protected AbstractExpression onCompile(TriggerFunctionContext context) throws ExpressionExecutionException {
        if (this.semanctiTypeName != null) {
            try {
                ArrayType semType = TypeFactory.createSemanticTypeType(this.semanctiTypeName, context);
                if (this.isArray) {
                    semType = TypeFactory.createArrayType(semType);
                }
                this.setResultType(semType);
            }
            catch (ClassNotFoundException exception) {
                throw new ExpressionExecutionException("Failed to load object of type '" + this.semanctiTypeName + "'.", this, exception);
            }
        }
        super.onCompile(context);
        return this;
    }

    @Override
    public void validate(TriggerFunctionContext context) throws ExpressionExecutionException {
        try {
            this.arguments[0].validate(context);
            if (this.arguments[0] instanceof ConstantExpression) {
                Expression.ValueTypeResult result = ((ConstantExpression)this.arguments[0]).evaluateValueType(context);
                this.getResultType().convertValue(result.value, result.type);
            }
        }
        catch (ValueConversionException exception) {
            throw new ExpressionExecutionException(exception.getMessage(), this, exception);
        }
    }

    @Override
    protected void onValidate(Type<?> type) throws ExpressionExecutionException, TypeConversionException {
    }

    @Override
    protected void onToString(StringBuilder builder) {
        builder.append("(");
        if (this.semanctiTypeName != null) {
            builder.append(this.semanctiTypeName);
        } else {
            builder.append(this.getResultType());
        }
        builder.append(")");
        this.arguments[0].toString(builder);
    }

    class CastValueAccessor
    extends AbstractTransactionalValueAccessor {
        CastValueAccessor(ValueAccessor parentValueAccessor) {
            super(parentValueAccessor);
        }

        @Override
        public Type<?> getType() {
            return CastOperation.this.getResultType();
        }

        @Override
        protected Object onGetValue(TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
            Object parentValue = this.parentValueAccessor.getValue(context);
            Type<?> parentType = this.parentValueAccessor.getType();
            if (parentType == CastOperation.this.getResultType()) {
                return parentValue;
            }
            return CastOperation.this.getResultType().convertValue(parentValue, parentType);
        }

        @Override
        protected void onAssignValue(Object value, Type<?> valueType, TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
            this.parentValueAccessor.assignValue(value, valueType, context);
        }

        @Override
        public String toString() {
            return CastOperation.this.toString();
        }

        @Override
        protected void resolveTypeInRuntime(TriggerFunctionContext context) throws ExpressionExecutionException, ValueConversionException {
        }
    }
}

